"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerAnnotationAPIs = registerAnnotationAPIs;
var t = _interopRequireWildcard(require("io-ts"));
var _configSchema = require("@kbn/config-schema");
var _Either = require("fp-ts/lib/Either");
var _securitysolutionIoTsUtils = require("@kbn/securitysolution-io-ts-utils");
var _annotations = require("../../../common/annotations");
var _create_annotations_client = require("./create_annotations_client");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const unknowns = _configSchema.schema.object({}, {
  unknowns: 'allow'
});
function registerAnnotationAPIs({
  core,
  index,
  logger
}) {
  function wrapRouteHandler(types, handler) {
    return async (...args) => {
      var _await$context$licens;
      const [context, request, response] = args;
      const rt = types;
      const data = {
        body: request.body,
        query: request.query,
        params: request.params
      };
      const validation = rt.decode(data);
      if ((0, _Either.isLeft)(validation)) {
        return response.badRequest({
          body: (0, _securitysolutionIoTsUtils.formatErrors)(validation.left).join('|')
        });
      }
      const esClient = (await context.core).elasticsearch.client.asCurrentUser;
      const license = (_await$context$licens = await context.licensing) === null || _await$context$licens === void 0 ? void 0 : _await$context$licens.license;
      const client = (0, _create_annotations_client.createAnnotationsClient)({
        index,
        esClient,
        logger,
        license
      });
      try {
        const res = await handler({
          data: validation.right,
          client
        });
        return response.ok({
          body: res
        });
      } catch (err) {
        var _err$output$statusCod, _err$output, _err$output$payload$m, _err$output2, _err$output2$payload;
        logger.error(err);
        return response.custom({
          statusCode: (_err$output$statusCod = (_err$output = err.output) === null || _err$output === void 0 ? void 0 : _err$output.statusCode) !== null && _err$output$statusCod !== void 0 ? _err$output$statusCod : 500,
          body: {
            message: (_err$output$payload$m = (_err$output2 = err.output) === null || _err$output2 === void 0 ? void 0 : (_err$output2$payload = _err$output2.payload) === null || _err$output2$payload === void 0 ? void 0 : _err$output2$payload.message) !== null && _err$output$payload$m !== void 0 ? _err$output$payload$m : 'An internal server error occurred'
          }
        });
      }
    };
  }
  const router = core.http.createRouter();
  router.post({
    path: '/api/observability/annotation',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      body: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({
    body: _annotations.createAnnotationRt
  }), ({
    data,
    client
  }) => {
    return client.create(data.body);
  }));
  router.put({
    path: '/api/observability/annotation/{id}',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      body: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({
    body: _annotations.updateAnnotationRt
  }), ({
    data,
    client
  }) => {
    return client.update(data.body);
  }));
  router.delete({
    path: '/api/observability/annotation/{id}',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      params: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({
    params: _annotations.deleteAnnotationRt
  }), ({
    data,
    client
  }) => {
    return client.delete(data.params);
  }));
  router.get({
    path: '/api/observability/annotation/{id}',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      params: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({
    params: _annotations.getAnnotationByIdRt
  }), ({
    data,
    client
  }) => {
    return client.getById(data.params);
  }));
  router.get({
    path: '/api/observability/annotation/find',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      query: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({
    query: _annotations.findAnnotationRt
  }), ({
    data,
    client
  }) => {
    return client.find(data.query);
  }));
  router.get({
    path: '/api/observability/annotation/permissions',
    security: {
      authz: {
        enabled: false,
        reason: 'This route delegates authorization to Elasticsearch'
      }
    },
    validate: {
      query: unknowns
    },
    options: {
      access: 'public'
    }
  }, wrapRouteHandler(t.type({}), ({
    client
  }) => {
    return client.permissions();
  }));
}