"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesFeatureV3 = void 0;
var _server = require("@kbn/core/server");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/features-plugin/common");
var _common2 = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesFeatureV3 = (casesCapabilities, casesApiTags) => ({
  id: _common2.casesFeatureIdV3,
  name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle', {
    defaultMessage: 'Cases'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: [_common2.casesFeatureId, 'kibana'],
  catalogue: [_common2.observabilityFeatureId],
  cases: [_common2.observabilityFeatureId],
  privileges: {
    all: {
      api: casesApiTags.all,
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: {
        create: [_common2.observabilityFeatureId],
        read: [_common2.observabilityFeatureId],
        update: [_common2.observabilityFeatureId],
        push: [_common2.observabilityFeatureId]
      },
      savedObject: {
        all: [..._saved_objects.hiddenTypes],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.all
    },
    read: {
      api: casesApiTags.read,
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: {
        read: [_common2.observabilityFeatureId]
      },
      savedObject: {
        all: [],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.read
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: casesApiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          delete: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.delete
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          settings: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.settings
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.addCommentsSubFeatureName', {
      defaultMessage: 'Create comments & attachments'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: casesApiTags.createComment,
        id: 'create_comment',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.addCommentsSubFeatureDetails', {
          defaultMessage: 'Add comments to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          createComment: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.createComment
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.reopenCaseSubFeatureName', {
      defaultMessage: 'Re-open'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'case_reopen',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.reopenCaseSubFeatureDetails', {
          defaultMessage: 'Re-open closed cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          reopenCase: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.reopenCase
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.features.assignUsersSubFeatureName', {
      defaultMessage: 'Assign users'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_assign',
        name: _i18n.i18n.translate('xpack.observability.features.assignUsersSubFeatureName', {
          defaultMessage: 'Assign users to cases'
        }),
        includeIn: 'all',
        savedObject: {
          all: [],
          read: []
        },
        cases: {
          assign: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.assignCase
      }]
    }]
  }]
});
exports.getCasesFeatureV3 = getCasesFeatureV3;