"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getCasesFeature = void 0;
var _server = require("@kbn/core/server");
var _saved_objects = require("@kbn/files-plugin/server/saved_objects");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/features-plugin/common");
var _common2 = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getCasesFeature = (casesCapabilities, casesApiTags) => ({
  deprecated: {
    // TODO: Add docLinks to link to documentation about the deprecation
    notice: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitle.deprecationMessage', {
      defaultMessage: 'The {currentId} permissions are deprecated, please see {casesFeatureIdV3}.',
      values: {
        currentId: _common2.casesFeatureId,
        casesFeatureIdV3: _common2.casesFeatureIdV3
      }
    })
  },
  id: _common2.casesFeatureId,
  name: _i18n.i18n.translate('xpack.observability.featureRegistry.linkObservabilityTitleDeprecated', {
    defaultMessage: 'Cases (Deprecated)'
  }),
  order: 1100,
  category: _server.DEFAULT_APP_CATEGORIES.observability,
  scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
  app: [_common2.casesFeatureId, 'kibana'],
  catalogue: [_common2.observabilityFeatureId],
  cases: [_common2.observabilityFeatureId],
  privileges: {
    all: {
      api: [...casesApiTags.all, ...casesApiTags.createComment],
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: {
        create: [_common2.observabilityFeatureId],
        read: [_common2.observabilityFeatureId],
        update: [_common2.observabilityFeatureId],
        push: [_common2.observabilityFeatureId],
        createComment: [_common2.observabilityFeatureId],
        reopenCase: [_common2.observabilityFeatureId],
        assign: [_common2.observabilityFeatureId]
      },
      savedObject: {
        all: [..._saved_objects.hiddenTypes],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: [...casesCapabilities.all, ...casesCapabilities.createComment, ...casesCapabilities.reopenCase, ...casesCapabilities.assignCase],
      replacedBy: {
        default: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['all']
        }],
        minimal: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['minimal_all', 'create_comment', 'case_reopen', 'cases_assign']
        }]
      }
    },
    read: {
      api: casesApiTags.read,
      app: [_common2.casesFeatureId, 'kibana'],
      catalogue: [_common2.observabilityFeatureId],
      cases: {
        read: [_common2.observabilityFeatureId]
      },
      savedObject: {
        all: [],
        read: [..._saved_objects.hiddenTypes]
      },
      ui: casesCapabilities.read,
      replacedBy: {
        default: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['read']
        }],
        minimal: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['minimal_read']
        }]
      }
    }
  },
  subFeatures: [{
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureName', {
      defaultMessage: 'Delete'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        api: casesApiTags.delete,
        id: 'cases_delete',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.deleteSubFeatureDetails', {
          defaultMessage: 'Delete cases and comments'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          delete: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.delete,
        replacedBy: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['cases_delete']
        }]
      }]
    }]
  }, {
    name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureName', {
      defaultMessage: 'Case settings'
    }),
    privilegeGroups: [{
      groupType: 'independent',
      privileges: [{
        id: 'cases_settings',
        name: _i18n.i18n.translate('xpack.observability.featureRegistry.casesSettingsSubFeatureDetails', {
          defaultMessage: 'Edit case settings'
        }),
        includeIn: 'all',
        savedObject: {
          all: [..._saved_objects.hiddenTypes],
          read: [..._saved_objects.hiddenTypes]
        },
        cases: {
          settings: [_common2.observabilityFeatureId]
        },
        ui: casesCapabilities.settings,
        replacedBy: [{
          feature: _common2.casesFeatureIdV3,
          privileges: ['cases_settings']
        }]
      }]
    }]
  }]
});
exports.getCasesFeature = getCasesFeature;