"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.generateInvestigationItem = void 0;
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const AggMappingForLens = {
  avg: 'average',
  cardinality: 'unique_count'
};
const genLensEqForCustomThresholdRule = criterion => {
  const metricNameResolver = {};
  criterion.metrics.forEach(metric => {
    const metricFilter = metric.filter ? `kql='${metric.filter}'` : '';
    if (metric.aggType === 'rate') {
      metricNameResolver[metric.name] = `counter_rate(max(${metric.field ? metric.field : metricFilter}))`;
    } else {
      metricNameResolver[metric.name] = `${AggMappingForLens[metric.aggType] ? AggMappingForLens[metric.aggType] : metric.aggType}(${metric.field ? metric.field : metricFilter})`;
    }
  });
  let equation = criterion.equation ? criterion.equation : criterion.metrics.map(m => m.name).join('+');
  Object.keys(metricNameResolver).sort().reverse().forEach(metricName => {
    equation = equation.replaceAll(metricName, metricNameResolver[metricName]);
  });
  return equation;
};
const generateInvestigationItem = (criterion, searchConfiguration, ruleTypeId, groupBy, groups) => {
  if (ruleTypeId === _ruleDataUtils.OBSERVABILITY_THRESHOLD_RULE_TYPE_ID) {
    const equation = genLensEqForCustomThresholdRule(criterion);
    const filters = searchConfiguration.filter || [];
    const additionalFilters = (0, _.getGroupFilters)(groups);
    const interval = `${criterion.timeSize}${criterion.timeUnit}`;
    const item = {
      title: equation,
      type: 'lens',
      params: {
        filters: [...filters, ...additionalFilters],
        equation,
        interval,
        searchConfiguration,
        groupBy
      }
    };
    return item;
  }
};
exports.generateInvestigationItem = generateInvestigationItem;