"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MetricWithSparkline = MetricWithSparkline;
var _charts = require("@elastic/charts");
var _eui = require("@elastic/eui");
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _use_chart_themes = require("../../../../../hooks/use_chart_themes");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function MetricWithSparkline({
  id,
  formatter,
  value,
  timeseries,
  color
}) {
  var _baseTheme$colors$viz, _baseTheme$colors;
  const {
    baseTheme,
    sparklineTheme
  } = (0, _use_chart_themes.useChartThemes)();
  const colors = (_baseTheme$colors$viz = (_baseTheme$colors = baseTheme.colors) === null || _baseTheme$colors === void 0 ? void 0 : _baseTheme$colors.vizColors) !== null && _baseTheme$colors$viz !== void 0 ? _baseTheme$colors$viz : [];
  if (!value) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
      color: "subdued"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "visLine"
    }), "\xA0", /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.metricWithSparkline.nATextColorLabel",
      defaultMessage: "N/A"
    }));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_charts.Chart, {
    size: {
      height: 18,
      width: 40
    }
  }, /*#__PURE__*/_react.default.createElement(_charts.Tooltip, {
    type: _charts.TooltipType.None
  }), /*#__PURE__*/_react.default.createElement(_charts.Settings, {
    baseTheme: baseTheme,
    theme: sparklineTheme,
    showLegend: false,
    locale: _i18n.i18n.getLocale()
  }), /*#__PURE__*/_react.default.createElement(_charts.AreaSeries, {
    id: id,
    data: timeseries,
    xAccessor: 'timestamp',
    yAccessors: [id],
    color: colors[color] || '#006BB4'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      whiteSpace: 'nowrap'
    }
  }, formatter(value)));
}