"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderActions = HeaderActions;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-shared-plugin/public");
var _date_picker = require("../date_picker/date_picker");
var _use_date_picker_context = require("../../../../hooks/use_date_picker_context");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HeaderActions({
  showTour = false,
  onGuidedSetupClick,
  onTimeRangeRefresh,
  onTourDismiss
}) {
  const buttonRef = (0, _react.useRef)();
  const {
    relativeStart,
    relativeEnd,
    refreshInterval,
    refreshPaused
  } = (0, _use_date_picker_context.useDatePickerContext)();
  const {
    endTour,
    isTourVisible
  } = (0, _public.useObservabilityTourContext)();
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    direction: "row",
    gutterSize: "s",
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_date_picker.DatePicker, {
    rangeFrom: relativeStart,
    rangeTo: relativeEnd,
    refreshInterval: refreshInterval,
    refreshPaused: refreshPaused,
    width: "auto",
    onTimeRangeRefresh: onTimeRangeRefresh
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton
  // @ts-expect-error the EUI verson that kibana uses right now doesn't have the correct types
  , {
    buttonRef: buttonRef,
    color: "text",
    "data-test-subj": "guidedSetupButton",
    id: "guidedSetupButton",
    iconType: "wrench",
    onClick: () => {
      if (isTourVisible) {
        endTour();
      }
      onGuidedSetupClick();
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.overview.guidedSetupButton",
    defaultMessage: "Data assistant"
  })), showTour ? /*#__PURE__*/_react.default.createElement(_eui.EuiTourStep
  // @ts-expect-error the EUI verson that kibana uses right now doesn't have the correct types
  , {
    anchor: () => buttonRef.current,
    step: 1,
    stepsTotal: 1,
    isStepOpen: true,
    maxWidth: 400,
    onFinish: onTourDismiss,
    title: _i18n.i18n.translate('xpack.observability.overview.guidedSetupTourTitle', {
      defaultMessage: 'Data assistant is always available'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "s"
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.overview.guidedSetupTourContent",
      defaultMessage: "If you're ever in doubt you can always access the data assistant and view your next steps by clicking here."
    })),
    footerAction: /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "o11yHeaderActionsDismissButton",
      color: "text",
      flush: "right",
      size: "xs",
      onClick: onTourDismiss
    }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observability.overview.guidedSetupTourDismissButton",
      defaultMessage: "Dismiss"
    }))
  }) : null));
}