"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LandingPage = LandingPage;
var _react = _interopRequireWildcard(require("react"));
var _locators = require("@kbn/deeplinks-observability/locators");
var _use_has_data = require("../../hooks/use_has_data");
var _kibana_react = require("../../utils/kibana_react");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LandingPage() {
  const {
    hasDataMap,
    isAllRequestsComplete
  } = (0, _use_has_data.useHasData)();
  const {
    application: {
      navigateToUrl,
      navigateToApp
    },
    http: {
      basePath
    },
    share: {
      url
    }
  } = (0, _kibana_react.useKibana)().services;
  (0, _react.useEffect)(() => {
    if (isAllRequestsComplete) {
      const {
        apm,
        infra_logs: logs
      } = hasDataMap;
      const hasApmData = apm === null || apm === void 0 ? void 0 : apm.hasData;
      const hasLogsData = logs === null || logs === void 0 ? void 0 : logs.hasData;
      if (hasLogsData) {
        const allDataSetsLocator = url.locators.get(_locators.ALL_DATASETS_LOCATOR_ID);
        allDataSetsLocator === null || allDataSetsLocator === void 0 ? void 0 : allDataSetsLocator.navigate({});
      } else if (hasApmData) {
        navigateToUrl(basePath.prepend('/app/apm/services'));
      } else {
        navigateToUrl(basePath.prepend('/app/observabilityOnboarding'));
      }
    }
  }, [basePath, hasDataMap, isAllRequestsComplete, navigateToApp, navigateToUrl, url.locators]);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null);
}