"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.LoadingObservability = LoadingObservability;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _use_plugin_context = require("../hooks/use_plugin_context");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function LoadingObservability() {
  const {
    ObservabilityPageTemplate
  } = (0, _use_plugin_context.usePluginContext)();
  return /*#__PURE__*/_react.default.createElement(ObservabilityPageTemplate, {
    pageSectionProps: {
      alignment: 'center'
    },
    showSolutionNav: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingSpinner, {
    size: "xl"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    style: {
      justifyContent: 'center'
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, null, observabilityLoadingMessage))));
}
const observabilityLoadingMessage = _i18n.i18n.translate('xpack.observability.overview.loadingObservability', {
  defaultMessage: 'Loading Observability'
});