"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnnotationRange = AnnotationRange;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactHookForm = require("react-hook-form");
var _react = _interopRequireDefault(require("react"));
var _public = require("@kbn/kibana-react-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getHelpfulDateFormat = dateFormat => {
  if (dateFormat.endsWith('HH:mm:ss.SSS')) {
    // we don't want microseconds in the date picker
    return dateFormat.replace(':ss.SSS', ':ss');
  }
  return dateFormat;
};
function AnnotationRange() {
  const {
    control,
    watch
  } = (0, _reactHookForm.useFormContext)();
  const eventEnd = watch('event.end');
  const dateFormatDefault = (0, _public.useUiSetting)('dateFormat');
  const dateFormat = getHelpfulDateFormat(dateFormatDefault);
  if (eventEnd) {
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.date', {
        defaultMessage: 'Timestamp'
      }),
      display: "rowCompressed",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      name: "@timestamp",
      control: control,
      rules: {
        required: true
      },
      render: ({
        field
      }) => {
        const {
          value,
          ref,
          ...rest
        } = field;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
          showTimeSelect: true,
          selected: field.value,
          fullWidth: true,
          compressed: true,
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.observability.annotationRange.fromFormLabelLabel', {
            defaultMessage: 'From'
          })),
          dateFormat: dateFormat
        }, rest));
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      display: "rowCompressed",
      fullWidth: true
    }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
      name: "event.end",
      control: control,
      rules: {
        required: true
      },
      render: ({
        field
      }) => {
        const {
          value,
          ref,
          ...rest
        } = field;
        return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
          showTimeSelect: true,
          selected: field.value,
          fullWidth: true,
          compressed: true,
          prepend: /*#__PURE__*/_react.default.createElement(_eui.EuiFormLabel, null, _i18n.i18n.translate('xpack.observability.annotationRange.toFormLabelLabel', {
            defaultMessage: 'To'
          })),
          dateFormat: dateFormat
        }, rest));
      }
    })));
  }
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: _i18n.i18n.translate('xpack.observability.annotationForm.euiFormRow.annotationDate', {
      defaultMessage: 'Annotation date'
    })
  }, /*#__PURE__*/_react.default.createElement(_reactHookForm.Controller, {
    name: "@timestamp",
    control: control,
    rules: {
      required: true
    },
    render: ({
      field
    }) => {
      const {
        value,
        ref,
        ...rest
      } = field;
      return /*#__PURE__*/_react.default.createElement(_eui.EuiDatePicker, (0, _extends2.default)({
        showTimeSelect: true,
        selected: field.value,
        compressed: true,
        dateFormat: dateFormat
      }, rest));
    }
  }));
}