"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutHeader = AlertsFlyoutHeader;
var _react = _interopRequireDefault(require("react"));
var _ruleDataUtils = require("@kbn/rule-data-utils");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _format_alert_title = require("../../utils/format_alert_title");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutHeader({
  alert
}) {
  var _alert$ALERT_RULE_CAT, _alert$ALERT_RULE_NAM;
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
    size: "m",
    "data-test-subj": "alertsFlyoutTitle"
  }, /*#__PURE__*/_react.default.createElement("h2", null, (0, _format_alert_title.getAlertTitle)((_alert$ALERT_RULE_CAT = alert[_ruleDataUtils.ALERT_RULE_CATEGORY]) === null || _alert$ALERT_RULE_CAT === void 0 ? void 0 : _alert$ALERT_RULE_CAT[0]))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    alignItems: "center"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s",
    color: "subdued"
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.observability.alertFlyout.title.ruleName",
    defaultMessage: "Rule"
  }), ":\xA0"), /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    size: "s"
  }, (_alert$ALERT_RULE_NAM = alert[_ruleDataUtils.ALERT_RULE_NAME]) === null || _alert$ALERT_RULE_NAM === void 0 ? void 0 : _alert$ALERT_RULE_NAM[0])));
}