"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AlertsFlyoutFooter = AlertsFlyoutFooter;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _reactRouterDom = require("react-router-dom");
var _common = require("@kbn/observability-shared-plugin/common");
var _parse_alert = require("../../pages/alerts/helpers/parse_alert");
var _kibana_react = require("../../utils/kibana_react");
var _paths = require("../../../common/locators/paths");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function AlertsFlyoutFooter({
  alert,
  tableId,
  observabilityRuleTypeRegistry
}) {
  const {
    http: {
      basePath: {
        prepend
      }
    }
  } = (0, _kibana_react.useKibana)().services;
  const isSLODetailsPage = (0, _reactRouterDom.useRouteMatch)(_paths.SLO_DETAIL_PATH);
  const parsedAlert = (0, _parse_alert.parseAlert)(observabilityRuleTypeRegistry)(alert);
  const viewInAppUrl = (0, _react.useMemo)(() => {
    if (!parsedAlert.hasBasePath) {
      var _parsedAlert$link;
      return prepend((_parsedAlert$link = parsedAlert.link) !== null && _parsedAlert$link !== void 0 ? _parsedAlert$link : '');
    }
    return parsedAlert.link;
  }, [parsedAlert.hasBasePath, parsedAlert.link, prepend]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlyoutFooter, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, !parsedAlert.link || isSLODetailsPage && tableId === _common.SLO_ALERTS_TABLE_ID ? null : /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutViewInAppButton",
    fill: true,
    href: viewInAppUrl
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.viewInAppButtonText', {
    defaultMessage: 'View in app'
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "alertsFlyoutAlertDetailsButton",
    fill: true,
    href: prepend && prepend(_paths.paths.observability.alertDetails(parsedAlert.fields['kibana.alert.uuid']))
  }, _i18n.i18n.translate('xpack.observability.alertsFlyout.alertsDetailsButtonText', {
    defaultMessage: 'Alert details'
  })))));
}