"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.renderApp = void 0;
var _react = _interopRequireDefault(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactQuery = require("@tanstack/react-query");
var _ebtTools = require("@kbn/ebt-tools");
var _public = require("@kbn/observability-shared-plugin/public");
var _i18n = require("@kbn/i18n");
var _sharedUxRouter = require("@kbn/shared-ux-router");
var _public2 = require("@kbn/core/public");
var _common = require("@kbn/kibana-react-plugin/common");
var _reactKibanaContextRender = require("@kbn/react-kibana-context-render");
var _public3 = require("@kbn/kibana-react-plugin/public");
var _reactKibanaContextTheme = require("@kbn/react-kibana-context-theme");
var _sharedUxLinkRedirectApp = require("@kbn/shared-ux-link-redirect-app");
var _public4 = require("@kbn/kibana-utils-plugin/public");
var _plugin_context = require("../context/plugin_context/plugin_context");
var _routes = require("../routes/routes");
var _hideable_react_query_dev_tools = require("./hideable_react_query_dev_tools");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function App() {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Routes, {
    enableExecutionContextTracking: true
  }, Object.keys(_routes.routes).map(key => {
    const path = key;
    const {
      handler,
      exact
    } = _routes.routes[path];
    const Wrapper = () => {
      return handler();
    };
    return /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Route, {
      key: path,
      path: path,
      exact: exact,
      component: Wrapper
    });
  })));
}
const renderApp = ({
  core,
  config,
  plugins,
  appMountParameters,
  observabilityRuleTypeRegistry,
  ObservabilityPageTemplate,
  usageCollection,
  isDev,
  kibanaVersion,
  isServerless
}) => {
  var _usageCollection$comp, _plugins$cloud$CloudC, _plugins$cloud;
  const {
    element,
    history,
    theme$
  } = appMountParameters;
  const isDarkMode = core.theme.getTheme().darkMode;
  core.chrome.setHelpExtension({
    appName: _i18n.i18n.translate('xpack.observability.feedbackMenu.appName', {
      defaultMessage: 'Observability'
    }),
    links: [{
      linkType: 'discuss',
      href: 'https://ela.st/observability-discuss'
    }]
  });

  // ensure all divs are .kbnAppWrappers
  element.classList.add(_public2.APP_WRAPPER_CLASS);
  const queryClient = new _reactQuery.QueryClient();
  const ApplicationUsageTrackingProvider = (_usageCollection$comp = usageCollection === null || usageCollection === void 0 ? void 0 : usageCollection.components.ApplicationUsageTrackingProvider) !== null && _usageCollection$comp !== void 0 ? _usageCollection$comp : _react.default.Fragment;
  const CloudProvider = (_plugins$cloud$CloudC = (_plugins$cloud = plugins.cloud) === null || _plugins$cloud === void 0 ? void 0 : _plugins$cloud.CloudContextProvider) !== null && _plugins$cloud$CloudC !== void 0 ? _plugins$cloud$CloudC : _react.default.Fragment;
  _reactDom.default.render(/*#__PURE__*/_react.default.createElement(_reactKibanaContextRender.KibanaRenderContextProvider, core, /*#__PURE__*/_react.default.createElement(ApplicationUsageTrackingProvider, null, /*#__PURE__*/_react.default.createElement(_reactKibanaContextTheme.KibanaThemeProvider, {
    theme: {
      theme$
    }
  }, /*#__PURE__*/_react.default.createElement(CloudProvider, null, /*#__PURE__*/_react.default.createElement(_public3.KibanaContextProvider, {
    services: {
      ...core,
      ...plugins,
      storage: new _public4.Storage(localStorage),
      isDev,
      kibanaVersion,
      isServerless
    }
  }, /*#__PURE__*/_react.default.createElement(_plugin_context.PluginContext.Provider, {
    value: {
      isDev,
      config,
      appMountParameters,
      observabilityRuleTypeRegistry,
      ObservabilityPageTemplate
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxRouter.Router, {
    history: history
  }, /*#__PURE__*/_react.default.createElement(_common.EuiThemeProvider, {
    darkMode: isDarkMode
  }, /*#__PURE__*/_react.default.createElement(_sharedUxLinkRedirectApp.RedirectAppLinks, {
    coreStart: core,
    "data-test-subj": "observabilityMainContainer"
  }, /*#__PURE__*/_react.default.createElement(_ebtTools.PerformanceContextProvider, null, /*#__PURE__*/_react.default.createElement(_reactQuery.QueryClientProvider, {
    client: queryClient
  }, /*#__PURE__*/_react.default.createElement(_public.InspectorContextProvider, null, /*#__PURE__*/_react.default.createElement(App, null), /*#__PURE__*/_react.default.createElement(_hideable_react_query_dev_tools.HideableReactQueryDevTools, null))))))))))))), element);
  return () => {
    // This needs to be present to fix https://github.com/elastic/kibana/issues/155704
    // as the Overview page renders the UX Section component. That component renders a Lens embeddable
    // via the ExploratoryView app, which uses search sessions. Therefore on unmounting we need to clear
    // these sessions.
    plugins.data.search.session.clear();
    _reactDom.default.unmountComponentAtNode(element);
  };
};
exports.renderApp = renderApp;