"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HideableReactQueryDevTools = HideableReactQueryDevTools;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _reactQueryDevtools = require("@tanstack/react-query-devtools");
var _eui = require("@elastic/eui");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function HideableReactQueryDevTools() {
  const [isHidden, setIsHidden] = (0, _react.useState)(false);
  return !isHidden && process.env.NODE_ENV === 'development' ? /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "data-test-subj": "o11yHideableReactQueryDevToolsButton",
    iconType: "cross",
    color: "primary",
    style: {
      zIndex: 99999,
      position: 'fixed',
      bottom: '40px',
      left: '40px'
    },
    onClick: () => setIsHidden(!isHidden),
    "aria-label": _i18n.i18n.translate('xpack.observability.hideableReactQueryDevTools.euiButtonIcon.hideReactQueryLabel', {
      defaultMessage: 'Hide react query'
    })
  }), /*#__PURE__*/_react.default.createElement(_reactQueryDevtools.ReactQueryDevtools, null)) : null;
}