"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelKubernetesPanel = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _public = require("@kbn/kibana-react-plugin/public");
var _i18nReact = require("@kbn/i18n-react");
var _deeplinksAnalytics = require("@kbn/deeplinks-analytics");
var _react2 = require("@emotion/react");
var _ebtTools = require("@kbn/ebt-tools");
var _empty_prompt = require("../shared/empty_prompt");
var _get_started_panel = require("../shared/get_started_panel");
var _feedback_buttons = require("../shared/feedback_buttons");
var _copy_to_clipboard_button = require("../shared/copy_to_clipboard_button");
var _use_kubernetes_flow = require("../kubernetes/use_kubernetes_flow");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OTEL_HELM_CHARTS_REPO = 'https://open-telemetry.github.io/opentelemetry-helm-charts';
const OTEL_KUBE_STACK_VERSION = '0.6.3';
const CLUSTER_OVERVIEW_DASHBOARD_ID = 'kubernetes_otel-cluster-overview';
const OtelKubernetesPanel = () => {
  var _data$elasticAgentVer, _dashboardLocator$get, _apmLocator$getRedire;
  const {
    data,
    error,
    refetch
  } = (0, _use_kubernetes_flow.useKubernetesFlow)('kubernetes_otel', {
    /**
     * This only needed for stateful deployments
     * of the stack version >=v8.18.0 <9.0.0.
     * On those clusters we cannot reference agent version
     * v8.x because those versions are not GA.
     * Instead we need to "manually" point to the GA
     * version, which starts from v9.0.0.
     */
    agentVersionPattern: '9.x.x'
  });
  const [idSelected, setIdSelected] = (0, _react.useState)('nodejs');
  const {
    services: {
      share
    }
  } = (0, _public.useKibana)();
  const apmLocator = share.url.locators.get('APM_LOCATOR');
  const dashboardLocator = share.url.locators.get(_deeplinksAnalytics.DASHBOARD_APP_LOCATOR);
  const theme = (0, _eui.useEuiTheme)();
  const {
    onPageReady
  } = (0, _ebtTools.usePerformanceContext)();
  (0, _react.useEffect)(() => {
    if (data) {
      onPageReady({
        meta: {
          description: `[ttfmp_onboarding] Request to create the onboarding flow succeeded and the flow's UI has rendered`
        }
      });
    }
  }, [data, onPageReady]);
  if (error) {
    return /*#__PURE__*/_react.default.createElement(_empty_prompt.EmptyPrompt, {
      onboardingFlowType: "kubernetes_otel",
      error: error,
      onRetryClick: refetch
    });
  }
  const agentVersion = (_data$elasticAgentVer = data === null || data === void 0 ? void 0 : data.elasticAgentVersionInfo.agentTargetVersion) !== null && _data$elasticAgentVer !== void 0 ? _data$elasticAgentVer : '';
  /**
   * Extracting the base version in case it has any suffix like `+build12345678`,
   * as in this flow agent version is used to reference the git tag without any
   * suffixes.
   */
  const agentBaseVersion = agentVersion.split('+')[0];
  const otelKubeStackValuesFileUrl = `https://raw.githubusercontent.com/elastic/elastic-agent/refs/tags/v${agentBaseVersion}/deploy/helm/edot-collector/kube-stack/values.yaml`;
  const namespace = 'opentelemetry-operator-system';
  const addRepoCommand = `helm repo add open-telemetry '${OTEL_HELM_CHARTS_REPO}' --force-update`;
  const installStackCommand = data ? `kubectl create namespace ${namespace}
kubectl create secret generic elastic-secret-otel \\
  --namespace ${namespace} \\
  --from-literal=elastic_endpoint='${data.elasticsearchUrl}' \\
  --from-literal=elastic_api_key='${data.apiKeyEncoded}'
helm upgrade --install opentelemetry-kube-stack open-telemetry/opentelemetry-kube-stack \\
  --namespace ${namespace} \\
  --values '${otelKubeStackValuesFileUrl}' \\
  --version '${OTEL_KUBE_STACK_VERSION}'` : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "xl"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSteps, {
    steps: [{
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.addRepositoryStepTitle', {
        defaultMessage: 'Add the OpenTelemetry repository to Helm'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash"
      }, addRepoCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
        textToCopy: addRepoCommand,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelAddRepositoryCopyToClipboard"
      }))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.installStackStepTitle', {
        defaultMessage: 'Install the OpenTelemetry Operator'
      }),
      children: installStackCommand ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelKubernetesPanel.injectAutoinstrumentationLibrariesForLabel",
        defaultMessage: "Install the OpenTelemetry Operator using the kube-stack Helm chart and the provided values file. Compatible with Helm up to version 8.14. For automatic certificate renewal, we recommend installing the {link}, and customize the values.yaml file before the installation as described {doc}.",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://cert-manager.io/docs/installation/",
            target: "_blank",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelCertManagerLink"
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.certmanagerLinkLabel', {
            defaultMessage: 'cert-manager'
          })),
          doc: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://ela.st/8-16-otel-cert-manager",
            target: "_blank",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelCertManagerDocsLink"
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.certmanagerDocsLinkLabel', {
            defaultMessage: 'in our documentation'
          }))
        }
      }), ' ', /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
        content: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.helmsAutogeneratedTLSCertificatesTextLabel', {
          defaultMessage: "Helm's autogenerated TLS certificates have a default expiration period of 365 days. These certificates are not renewed automatically unless the release is manually updated. Enabling cert-manager allows for automatic certificate renewal."
        }),
        position: "top",
        type: "info"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash"
      }, installStackCommand), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        alignItems: "center",
        justifyContent: "flexStart"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_copy_to_clipboard_button.CopyToClipboardButton, {
        textToCopy: installStackCommand,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelInstallStackCopyToClipboard"
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
        iconType: "download",
        href: otelKubeStackValuesFileUrl,
        flush: "left",
        target: "_blank" // The `download` attribute does not work cross-origin so it's better to open the file in a new tab
        ,
        "data-test-subj": "observabilityOnboardingOtelKubernetesPanelDownloadValuesFileButton"
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.downloadValuesFileButtonEmptyLabel', {
        defaultMessage: 'Download values file'
      }))))) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6
      })
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.instrumentApplicationStepTitle', {
        defaultMessage: 'Instrument your application (optional)'
      }),
      children: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.theOperatorAutomatesTheLabel', {
        defaultMessage: 'The Operator automates the injection of auto-instrumentation libraries into the annotated pods for some languages.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonGroup, {
        legend: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.selectProgrammingLanguageLegend', {
          defaultMessage: 'Select a programming language'
        }),
        idSelected: idSelected,
        onChange: optionId => setIdSelected(optionId),
        options: [{
          id: 'nodejs',
          label: 'Node.js'
        }, {
          id: 'java',
          label: 'Java'
        }, {
          id: 'python',
          label: 'Python'
        }, {
          id: 'dotnet',
          label: '.NET'
        }, {
          id: 'go',
          label: 'Go'
        }]
      }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", {
        css: (0, _react2.css)`
                    font-weight: ${theme.euiTheme.font.weight.bold};
                  `
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.step3a.title', {
        defaultMessage: '3(a) - Start with one of these annotations methods:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: 'otelKubernetesAccordionSingleDeployment',
        paddingSize: "s",
        buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.annotation.deployment', {
          defaultMessage: 'Annotate specific deployment Pods modifying its manifest'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "yaml",
        isCopyable: true
      }, `apiVersion: apps/v1
kind: Deployment
metadata:
  name: myapp
spec:
  ...
  template:
    metadata:
      annotations:
        instrumentation.opentelemetry.io/inject-${idSelected}: "${namespace}/elastic-instrumentation"
      ...
    spec:
      containers:
      - image: myapplication-image
        name: app
      ...`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiAccordion, {
        id: 'otelKubernetesAccordionAllResources',
        paddingSize: "s",
        buttonContent: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.annotation.resources', {
          defaultMessage: 'Annotate all resources in a namespace'
        })
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        isCopyable: true
      }, `kubectl annotate namespace my-namespace instrumentation.opentelemetry.io/inject-${idSelected}="${namespace}/elastic-instrumentation"`)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", {
        css: (0, _react2.css)`
                    font-weight: ${theme.euiTheme.font.weight.bold};
                  `
      }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.step3b.title', {
        defaultMessage: '3(b) - Restart deployment and ensure the annotations are applied and the auto-instrumentation library is injected:'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
        paddingSize: "m",
        language: "bash",
        isCopyable: true
      }, `kubectl rollout restart deployment myapp -n my-namespace

kubectl describe pod <myapp-pod-name> -n my-namespace`), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.observability_onboarding.otelKubernetesPanel.forOtherLanguagesThatLabel",
        defaultMessage: "For other languages where auto-instrumentation is not available, {link}",
        values: {
          link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            href: "https://ela.st/8-16-otel-apm-instrumentation",
            "data-test-subj": "observabilityOnboardingOtelKubernetesPanelReferToTheDocumentationLink",
            target: "_blank"
          }, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.referToTheDocumentationLinkLabel', {
            defaultMessage: 'refer to the documentation'
          }))
        }
      })))
    }, {
      title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.monitorStepTitle', {
        defaultMessage: 'Visualize your data'
      }),
      children: data ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.onceYourKubernetesInfrastructureLabel', {
        defaultMessage: 'Analyze your Kubernetes cluster’s health and monitor your container workloads.'
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null), /*#__PURE__*/_react.default.createElement(_get_started_panel.GetStartedPanel, {
        onboardingFlowType: "kubernetes_otel",
        onboardingId: data.onboardingId,
        dataset: "kubernetes",
        integration: "kubernetes_otel",
        newTab: false,
        isLoading: false,
        actionLinks: [{
          id: CLUSTER_OVERVIEW_DASHBOARD_ID,
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.monitoringCluster', {
            defaultMessage: 'Check your Kubernetes cluster health:'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.exploreDashboard', {
            defaultMessage: 'Explore Kubernetes Cluster Dashboard'
          }),
          href: (_dashboardLocator$get = dashboardLocator === null || dashboardLocator === void 0 ? void 0 : dashboardLocator.getRedirectUrl({
            dashboardId: CLUSTER_OVERVIEW_DASHBOARD_ID
          })) !== null && _dashboardLocator$get !== void 0 ? _dashboardLocator$get : ''
        }, {
          id: 'services',
          title: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.servicesTitle', {
            defaultMessage: 'Check your application services:'
          }),
          label: _i18n.i18n.translate('xpack.observability_onboarding.otelKubernetesPanel.servicesLabel', {
            defaultMessage: 'Explore Service Inventory'
          }),
          href: (_apmLocator$getRedire = apmLocator === null || apmLocator === void 0 ? void 0 : apmLocator.getRedirectUrl({
            serviceName: undefined
          })) !== null && _apmLocator$getRedire !== void 0 ? _apmLocator$getRedire : ''
        }]
      })) : /*#__PURE__*/_react.default.createElement(_eui.EuiSkeletonText, {
        lines: 6
      })
    }]
  }), /*#__PURE__*/_react.default.createElement(_feedback_buttons.FeedbackButtons, {
    flow: "otel_kubernetes"
  }));
};
exports.OtelKubernetesPanel = OtelKubernetesPanel;