"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAutoDetectCommand = getAutoDetectCommand;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getAutoDetectCommand(options) {
  const scriptName = 'auto_detect.sh';
  return oneLine`
    curl ${options.scriptDownloadUrl} -so ${scriptName} &&
    sudo bash ${scriptName}
      --id=${options.onboardingFlow.id}
      --kibana-url=${options.kibanaUrl}
      --install-key=${options.installApiKey}
      --ingest-key=${options.ingestApiKey}
      --ea-version=${options.elasticAgentVersionInfo.agentVersion}
  `;
}
function oneLine(parts, ...args) {
  const str = (0, _lodash.flatten)((0, _lodash.zip)(parts, args)).join('');
  return str.replace(/\s+/g, ' ').trim();
}