"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.OtelKubernetesPage = void 0;
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _otel_kubernetes_panel = require("../quickstart_flows/otel_kubernetes/otel_kubernetes_panel");
var _template = require("./template");
var _header = require("../header");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const OtelKubernetesPage = () => /*#__PURE__*/_react.default.createElement(_template.PageTemplate, {
  customHeader: /*#__PURE__*/_react.default.createElement(_header.CustomHeader, {
    logo: "opentelemetry",
    headlineCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otelKubernetes.text', {
      defaultMessage: 'Elastic Distribution for OTel Collector'
    }),
    captionCopy: _i18n.i18n.translate('xpack.observability_onboarding.experimentalOnboardingFlow.customHeader.otelKubernetes.caption.description', {
      defaultMessage: 'Unified Kubernetes observability with the OpenTelemetry Operator'
    })
  })
}, /*#__PURE__*/_react.default.createElement(_otel_kubernetes_panel.OtelKubernetesPanel, null));
exports.OtelKubernetesPage = OtelKubernetesPage;