"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.initializeFromLocationState = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const initializeFromLocationState = ({
  history
}) => (context, event) => callback => {
  var _history$location, _history$location$sta;
  const origin = (_history$location = history.location) === null || _history$location === void 0 ? void 0 : (_history$location$sta = _history$location.state) === null || _history$location$sta === void 0 ? void 0 : _history$location$sta.origin;
  if (!origin) {
    return callback('INITIALIZED_WITH_NO_ORIGIN');
  } else if (origin.id === 'application-log-onboarding') {
    return callback('INITIALIZED_WITH_ONBOARDING_ORIGIN');
  }
};
exports.initializeFromLocationState = initializeFromLocationState;