"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stateFromUntrustedUrlRT = exports.getUrlValueFromState = exports.getStateFromUrlValue = void 0;
var rt = _interopRequireWildcard(require("io-ts"));
var _common = require("../../../../common");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getStateFromUrlValue = urlValue => (0, _common.deepCompactObject)({
  chart: {
    breakdownField: urlValue.breakdownField
  },
  controls: urlValue.controls,
  dataSourceSelection: urlValue.datasetSelection,
  filters: urlValue.filters,
  grid: {
    columns: urlValue.columns,
    rows: {
      rowHeight: urlValue.rowHeight,
      rowsPerPage: urlValue.rowsPerPage
    }
  },
  query: urlValue.query,
  refreshInterval: urlValue.refreshInterval,
  time: urlValue.time
});
exports.getStateFromUrlValue = getStateFromUrlValue;
const getUrlValueFromState = state => {
  var _state$chart, _state$grid, _state$grid2, _state$grid2$rows, _state$grid3, _state$grid3$rows;
  return (0, _common.deepCompactObject)({
    breakdownField: (_state$chart = state.chart) === null || _state$chart === void 0 ? void 0 : _state$chart.breakdownField,
    columns: (_state$grid = state.grid) === null || _state$grid === void 0 ? void 0 : _state$grid.columns,
    controls: state.controls,
    datasetSelection: state.dataSourceSelection,
    filters: state.filters,
    query: state.query,
    refreshInterval: state.refreshInterval,
    rowHeight: (_state$grid2 = state.grid) === null || _state$grid2 === void 0 ? void 0 : (_state$grid2$rows = _state$grid2.rows) === null || _state$grid2$rows === void 0 ? void 0 : _state$grid2$rows.rowHeight,
    rowsPerPage: (_state$grid3 = state.grid) === null || _state$grid3 === void 0 ? void 0 : (_state$grid3$rows = _state$grid3.rows) === null || _state$grid3$rows === void 0 ? void 0 : _state$grid3$rows.rowsPerPage,
    time: state.time,
    v: 1
  });
};
exports.getUrlValueFromState = getUrlValueFromState;
const stateFromUrlSchemaRT = new rt.Type('stateFromUrlSchemaRT', rt.never.is, (urlSchema, context) => rt.success(getStateFromUrlValue(urlSchema)), getUrlValueFromState);
const stateFromUntrustedUrlRT = exports.stateFromUntrustedUrlRT = _common.logsExplorerUrlSchemaV1.urlSchemaRT.pipe(stateFromUrlSchemaRT);