"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getConcreteWriteIndex = getConcreteWriteIndex;
exports.getInferenceIdFromWriteIndex = getInferenceIdFromWriteIndex;
var _lodash = require("lodash");
var _ = require("..");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getConcreteWriteIndex(esClient) {
  try {
    const res = await esClient.asInternalUser.indices.getAlias({
      name: _.resourceNames.writeIndexAlias.kb
    });
    return (0, _lodash.first)(Object.keys(res));
  } catch (error) {
    return;
  }
}
async function getInferenceIdFromWriteIndex(esClient) {
  var _indexMappings$mappin, _indexMappings$mappin2, _indexMappings$mappin3;
  const response = await esClient.asInternalUser.indices.getMapping({
    index: _.resourceNames.writeIndexAlias.kb
  });
  const [indexName, indexMappings] = Object.entries(response)[0];
  const inferenceId = (_indexMappings$mappin = indexMappings.mappings) === null || _indexMappings$mappin === void 0 ? void 0 : (_indexMappings$mappin2 = _indexMappings$mappin.properties) === null || _indexMappings$mappin2 === void 0 ? void 0 : (_indexMappings$mappin3 = _indexMappings$mappin2.semantic_text) === null || _indexMappings$mappin3 === void 0 ? void 0 : _indexMappings$mappin3.inference_id;
  if (!inferenceId) {
    throw new Error(`inference_id not found in field mappings for index ${indexName}`);
  }
  return inferenceId;
}