"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.knowledgeBaseRoutes = void 0;
var _ioTsUtils = require("@kbn/io-ts-utils");
var t = _interopRequireWildcard(require("io-ts"));
var _create_observability_ai_assistant_server_route = require("../create_observability_ai_assistant_server_route");
var _types = require("../../../common/types");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getKnowledgeBaseStatus = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/status',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    return client.getKnowledgeBaseStatus();
  }
});
const setupKnowledgeBase = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/setup',
  params: t.type({
    query: t.intersection([t.type({
      inference_id: t.string
    }), t.partial({
      wait_until_complete: _ioTsUtils.toBooleanRt
    })])
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      inference_id: inferenceId,
      wait_until_complete: waitUntilComplete
    } = resources.params.query;
    return client.setupKnowledgeBase(inferenceId, waitUntilComplete);
  }
});
const warmupModelKnowledgeBase = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/warmup_model',
  params: t.type({
    query: t.type({
      inference_id: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      inference_id: inferenceId
    } = resources.params.query;
    return client.warmupKbModel(inferenceId);
  }
});
const reIndexKnowledgeBase = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/reindex',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    await client.reIndexKnowledgeBaseWithLock();
    return {
      success: true
    };
  }
});
const startupMigrationsKnowledgeBase = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/migrations/startup',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    return client.runStartupMigrations();
  }
});
const getKnowledgeBaseInferenceEndpoints = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/inference_endpoints',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    return {
      endpoints: await client.getInferenceEndpointsForEmbedding()
    };
  }
});
const getKnowledgeBaseUserInstructions = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/user_instructions',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    return {
      userInstructions: await client.getKnowledgeBaseUserInstructions()
    };
  }
});
const saveKnowledgeBaseUserInstruction = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'PUT /internal/observability_ai_assistant/kb/user_instructions',
  params: t.type({
    body: t.type({
      id: t.string,
      text: _ioTsUtils.nonEmptyStringRt,
      public: _ioTsUtils.toBooleanRt
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      id,
      text,
      public: isPublic
    } = resources.params.body;
    return client.addUserInstruction({
      entry: {
        id,
        text,
        public: isPublic,
        title: `User instruction`
      }
    });
  }
});
const getKnowledgeBaseEntries = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'GET /internal/observability_ai_assistant/kb/entries',
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  params: t.type({
    query: t.type({
      query: t.string,
      sortBy: t.string,
      sortDirection: t.union([t.literal('asc'), t.literal('desc')])
    })
  }),
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      query,
      sortBy,
      sortDirection
    } = resources.params.query;
    return client.getKnowledgeBaseEntries({
      query,
      sortBy,
      sortDirection
    });
  }
});
const knowledgeBaseEntryRt = t.intersection([t.type({
  id: t.string,
  title: t.string,
  text: _ioTsUtils.nonEmptyStringRt
}), t.partial({
  public: _ioTsUtils.toBooleanRt,
  labels: t.record(t.string, t.string),
  role: t.union([t.literal(_types.KnowledgeBaseEntryRole.AssistantSummarization), t.literal(_types.KnowledgeBaseEntryRole.UserEntry), t.literal(_types.KnowledgeBaseEntryRole.Elastic)])
})]);
const saveKnowledgeBaseEntry = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/entries/save',
  params: t.type({
    body: knowledgeBaseEntryRt
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const entry = resources.params.body;
    return client.addKnowledgeBaseEntry({
      entry: {
        public: true,
        labels: {},
        role: _types.KnowledgeBaseEntryRole.UserEntry,
        ...entry
      }
    });
  }
});
const deleteKnowledgeBaseEntry = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'DELETE /internal/observability_ai_assistant/kb/entries/{entryId}',
  params: t.type({
    path: t.type({
      entryId: t.string
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    return client.deleteKnowledgeBaseEntry(resources.params.path.entryId);
  }
});
const importKnowledgeBaseEntries = (0, _create_observability_ai_assistant_server_route.createObservabilityAIAssistantServerRoute)({
  endpoint: 'POST /internal/observability_ai_assistant/kb/entries/import',
  params: t.type({
    body: t.type({
      entries: t.array(knowledgeBaseEntryRt)
    })
  }),
  security: {
    authz: {
      requiredPrivileges: ['ai_assistant']
    }
  },
  handler: async resources => {
    const client = await resources.service.getClient({
      request: resources.request
    });
    const {
      kbState
    } = await client.getKnowledgeBaseStatus();
    if (kbState !== _types.KnowledgeBaseState.READY) {
      throw new Error('Knowledge base is not ready');
    }
    const entries = resources.params.body.entries.map(entry => ({
      public: true,
      labels: {},
      role: _types.KnowledgeBaseEntryRole.UserEntry,
      ...entry
    }));
    await client.addKnowledgeBaseBulkEntries({
      entries
    });
    resources.logger.info(`Imported ${entries.length} knowledge base entries`);
  }
});
const knowledgeBaseRoutes = exports.knowledgeBaseRoutes = {
  ...reIndexKnowledgeBase,
  ...startupMigrationsKnowledgeBase,
  ...setupKnowledgeBase,
  ...reIndexKnowledgeBase,
  ...getKnowledgeBaseStatus,
  ...getKnowledgeBaseEntries,
  ...saveKnowledgeBaseUserInstruction,
  ...importKnowledgeBaseEntries,
  ...getKnowledgeBaseUserInstructions,
  ...saveKnowledgeBaseEntry,
  ...deleteKnowledgeBaseEntry,
  ...getKnowledgeBaseInferenceEndpoints,
  ...warmupModelKnowledgeBase
};