"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ObservabilityAIAssistantPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _server = require("@kbn/core/server");
var _lodash = require("lodash");
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/features-plugin/common");
var _coreSecurityServer = require("@kbn/core-security-server");
var _feature = require("../common/feature");
var _register_routes = require("./routes/register_routes");
var _service = require("./service");
var _functions = require("./functions");
var _recall_ranking = require("./analytics/recall_ranking");
var _capabilities = require("../common/capabilities");
var _run_startup_migrations = require("./service/startup_migrations/run_startup_migrations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class ObservabilityAIAssistantPlugin {
  constructor(context) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    (0, _defineProperty2.default)(this, "config", void 0);
    (0, _defineProperty2.default)(this, "service", void 0);
    this.logger = context.logger.get();
    this.config = context.config.get();
  }
  setup(core, plugins) {
    plugins.features.registerKibanaFeature({
      id: _feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID,
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.featureRegistry.featureName', {
        defaultMessage: 'Observability AI Assistant'
      }),
      order: 8600,
      category: _server.DEFAULT_APP_CATEGORIES.observability,
      scope: [_common.KibanaFeatureScope.Spaces, _common.KibanaFeatureScope.Security],
      app: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'kibana'],
      catalogue: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID],
      minimumLicense: 'enterprise',
      // see x-pack/platform/plugins/shared/features/common/feature_kibana_privileges.ts
      privileges: {
        all: {
          app: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'kibana'],
          api: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID, 'ai_assistant', _coreSecurityServer.ApiPrivileges.manage('llm_product_doc')],
          catalogue: [_feature.OBSERVABILITY_AI_ASSISTANT_FEATURE_ID],
          savedObject: {
            all: [],
            read: []
          },
          ui: [_capabilities.aiAssistantCapabilities.show]
        },
        read: {
          disabled: true,
          savedObject: {
            all: [],
            read: []
          },
          ui: []
        }
      }
    });
    const routeHandlerPlugins = (0, _lodash.mapValues)(plugins, (value, key) => {
      return {
        setup: value,
        start: () => core.getStartServices().then(services => {
          const [, pluginsStartContracts] = services;
          return pluginsStartContracts[key];
        })
      };
    });
    const withCore = {
      ...routeHandlerPlugins,
      core: {
        setup: core,
        start: () => core.getStartServices().then(([coreStart]) => coreStart)
      }
    };
    const service = this.service = new _service.ObservabilityAIAssistantService({
      logger: this.logger.get('service'),
      core,
      config: this.config
    });

    // Update existing index assets (mappings, templates, etc). This will not create assets if they do not exist.

    (0, _run_startup_migrations.runStartupMigrations)({
      core,
      logger: this.logger,
      config: this.config
    }).catch(e => this.logger.error(`Error while running startup migrations: ${e.message}`));
    service.register(_functions.registerFunctions);
    (0, _register_routes.registerServerRoutes)({
      core,
      logger: this.logger,
      dependencies: {
        plugins: withCore,
        service: this.service
      }
    });
    core.analytics.registerEventType(_recall_ranking.recallRankingEvent);
    return {
      service
    };
  }
  start() {
    return {
      service: this.service
    };
  }
}
exports.ObservabilityAIAssistantPlugin = ObservabilityAIAssistantPlugin;