"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useGenAIConnectors = useGenAIConnectors;
exports.useGenAIConnectorsWithoutContext = useGenAIConnectorsWithoutContext;
var _react = require("react");
var _useLocalStorage = _interopRequireDefault(require("react-use/lib/useLocalStorage"));
var _use_observability_ai_assistant = require("./use_observability_ai_assistant");
var _use_kibana = require("./use_kibana");
var _inference_endpoint_exists = require("./inference_endpoint_exists");
var _get_elastic_managed_llm_connector = require("../utils/get_elastic_managed_llm_connector");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useGenAIConnectors() {
  const assistant = (0, _use_observability_ai_assistant.useObservabilityAIAssistant)();
  return useGenAIConnectorsWithoutContext(assistant);
}
function useGenAIConnectorsWithoutContext(assistant) {
  var _connectors$;
  const [connectors, setConnectors] = (0, _react.useState)(undefined);
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const [selectedConnector, setSelectedConnector] = (0, _useLocalStorage.default)(`xpack.observabilityAiAssistant.lastUsedConnector`, '');
  const [loading, setLoading] = (0, _react.useState)(false);
  const [error, setError] = (0, _react.useState)(undefined);
  const controller = (0, _react.useMemo)(() => new AbortController(), []);
  const fetchConnectors = (0, _react.useCallback)(async () => {
    setLoading(true);
    assistant.callApi('GET /internal/observability_ai_assistant/connectors', {
      signal: controller.signal
    }).then(results => {
      return results.reduce(async (result, connector) => {
        var _config;
        if (connector.actionTypeId !== _get_elastic_managed_llm_connector.INFERENCE_CONNECTOR_ACTION_TYPE_ID || connector.actionTypeId === _get_elastic_managed_llm_connector.INFERENCE_CONNECTOR_ACTION_TYPE_ID && (await (0, _inference_endpoint_exists.isInferenceEndpointExists)(http, connector === null || connector === void 0 ? void 0 : (_config = connector.config) === null || _config === void 0 ? void 0 : _config.inferenceId))) {
          return [...(await result), connector];
        }
        return result;
      }, Promise.resolve([])).then(c => {
        setConnectors(c);
        setSelectedConnector(connectorId => {
          if (connectorId && c.findIndex(result => result.id === connectorId) === -1) {
            return '';
          }
          return connectorId;
        });
        setError(undefined);
      });
    }).catch(err => {
      setError(err);
      setConnectors(undefined);
    }).finally(() => {
      setLoading(false);
    });
  }, [assistant, controller.signal, http, setSelectedConnector]);
  (0, _react.useEffect)(() => {
    fetchConnectors();
    return () => {
      controller.abort();
    };
  }, [assistant, controller, fetchConnectors, setSelectedConnector]);
  return {
    connectors,
    loading,
    error,
    selectedConnector: selectedConnector || (connectors === null || connectors === void 0 ? void 0 : (_connectors$ = connectors[0]) === null || _connectors$ === void 0 ? void 0 : _connectors$.id),
    selectConnector: id => {
      setSelectedConnector(id);
    },
    reloadConnectors: () => {
      fetchConnectors();
    }
  };
}