"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MessageRole = exports.KnowledgeBaseType = exports.KnowledgeBaseState = exports.KnowledgeBaseEntryRole = exports.ConversationAccess = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
let MessageRole = exports.MessageRole = /*#__PURE__*/function (MessageRole) {
  MessageRole["System"] = "system";
  MessageRole["Assistant"] = "assistant";
  MessageRole["User"] = "user";
  MessageRole["Function"] = "function";
  MessageRole["Elastic"] = "elastic";
  return MessageRole;
}({});
let KnowledgeBaseEntryRole = exports.KnowledgeBaseEntryRole = /*#__PURE__*/function (KnowledgeBaseEntryRole) {
  KnowledgeBaseEntryRole["AssistantSummarization"] = "assistant_summarization";
  KnowledgeBaseEntryRole["UserEntry"] = "user_entry";
  KnowledgeBaseEntryRole["Elastic"] = "elastic";
  return KnowledgeBaseEntryRole;
}({});
let KnowledgeBaseType = exports.KnowledgeBaseType = /*#__PURE__*/function (KnowledgeBaseType) {
  KnowledgeBaseType["UserInstruction"] = "user_instruction";
  KnowledgeBaseType["Contextual"] = "contextual";
  return KnowledgeBaseType;
}({});
let KnowledgeBaseState = exports.KnowledgeBaseState = /*#__PURE__*/function (KnowledgeBaseState) {
  KnowledgeBaseState["NOT_INSTALLED"] = "NOT_INSTALLED";
  KnowledgeBaseState["MODEL_PENDING_DEPLOYMENT"] = "MODEL_PENDING_DEPLOYMENT";
  KnowledgeBaseState["DEPLOYING_MODEL"] = "DEPLOYING_MODEL";
  KnowledgeBaseState["MODEL_PENDING_ALLOCATION"] = "MODEL_PENDING_ALLOCATION";
  KnowledgeBaseState["READY"] = "READY";
  KnowledgeBaseState["ERROR"] = "ERROR";
  return KnowledgeBaseState;
}({});
let ConversationAccess = exports.ConversationAccess = /*#__PURE__*/function (ConversationAccess) {
  ConversationAccess["SHARED"] = "shared";
  ConversationAccess["PRIVATE"] = "private";
  return ConversationAccess;
}({});