"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SettingsTab = SettingsTab;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/observability-ai-assistant-plugin/public");
var _hooks = require("@kbn/ai-assistant/src/hooks");
var _use_app_context = require("../../../hooks/use_app_context");
var _use_kibana = require("../../../hooks/use_kibana");
var _ui_settings = require("./ui_settings");
var _product_doc_entry = require("./product_doc_entry");
var _change_kb_model = require("./change_kb_model");
var _inference_utils = require("../../../helpers/inference_utils");
var _use_product_doc = require("../../../hooks/use_product_doc");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const GoToSpacesButton = ({
  getUrlForSpaces
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    iconSide: "right",
    "data-test-subj": "settingsTabGoToSpacesButton",
    href: getUrlForSpaces(),
    target: "_blank",
    rel: "noopener noreferrer"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.goToSpacesButtonLabel', {
    defaultMessage: 'Go to spaces'
  }));
};
function SettingsTab() {
  var _knowledgeBase$status, _docLinks$links, _docLinks$links$obser, _knowledgeBase$status2, _connectors$connector;
  const {
    application: {
      getUrlForApp
    },
    productDocBase,
    http,
    docLinks
  } = (0, _use_kibana.useKibana)().services;
  const {
    config
  } = (0, _use_app_context.useAppContext)();
  const knowledgeBase = (0, _hooks.useKnowledgeBase)();
  const currentlyDeployedInferenceId = (0, _inference_utils.getMappedInferenceId)((_knowledgeBase$status = knowledgeBase.status.value) === null || _knowledgeBase$status === void 0 ? void 0 : _knowledgeBase$status.currentInferenceId);
  const productDoc = (0, _use_product_doc.useProductDoc)(currentlyDeployedInferenceId);
  const connectors = (0, _hooks.useGenAIConnectors)();
  const elasticManagedLlm = (0, _public.getElasticManagedLlmConnector)(connectors.connectors);
  const getUrlForSpaces = () => {
    return getUrlForApp('management', {
      path: '/kibana/spaces'
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    grow: false
  }, config.spacesEnabled && /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.showAIAssistantButtonLabel', {
      defaultMessage: 'Show AI Assistant button and Contextual Insights in Observability apps'
    })),
    description: /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.showAIAssistantDescriptionLabel', {
      defaultMessage: 'Toggle the AI Assistant button and Contextual Insights on or off in Observability apps by checking or unchecking the AI Assistant feature in Spaces > <your space> > Features.',
      ignoreTag: true
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(GoToSpacesButton, {
    getUrlForSpaces: getUrlForSpaces
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiDescribedFormGroup, {
    fullWidth: true,
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      alignItems: "center",
      responsive: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
      type: "sparkles",
      size: "m"
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h3", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.aiConnectorLabel', {
      defaultMessage: 'AI Connector'
    }))))),
    description: !!elasticManagedLlm ? /*#__PURE__*/_react.default.createElement("p", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.observabilityAiAssistantManagement.settingsPage.aiConnectorDescriptionWithLink",
      defaultMessage: `Elastic AI Assistant and other AI features are powered by an LLM. The Elastic Managed LLM connector is used by default ({link}) when no custom connectors are available. Select "Manage connectors" to configure and use a custom connector.`,
      values: {
        link: /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
          "data-test-subj": "observabilityAiAssistantManagementSettingsTabAdditionalCostsIncurLink",
          href: docLinks === null || docLinks === void 0 ? void 0 : (_docLinks$links = docLinks.links) === null || _docLinks$links === void 0 ? void 0 : (_docLinks$links$obser = _docLinks$links.observability) === null || _docLinks$links$obser === void 0 ? void 0 : _docLinks$links$obser.elasticManagedLlmUsageCost,
          target: "_blank"
        }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.additionalCostsLink', {
          defaultMessage: 'additional costs incur'
        }))
      }
    })) : /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.aiConnectorDescription', {
      defaultMessage: 'A large language model (LLM) is required to power the AI Assistant and AI-driven features in Elastic. In order to use the AI Assistant you must set up a Generative AI connector.'
    }))
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    responsive: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    iconType: "popout",
    iconSide: "right",
    "data-test-subj": "settingsTabGoToConnectorsButton",
    href: (0, _public.getConnectorsManagementHref)(http),
    target: "_blank",
    rel: "noopener noreferrer"
  }, _i18n.i18n.translate('xpack.observabilityAiAssistantManagement.settingsPage.goToConnectorsButtonLabel', {
    defaultMessage: 'Manage connectors'
  })))))), productDocBase ? /*#__PURE__*/_react.default.createElement(_product_doc_entry.ProductDocEntry, {
    knowledgeBase: knowledgeBase,
    productDoc: productDoc,
    currentlyDeployedInferenceId: currentlyDeployedInferenceId
  }) : undefined, (_knowledgeBase$status2 = knowledgeBase.status.value) !== null && _knowledgeBase$status2 !== void 0 && _knowledgeBase$status2.enabled && (_connectors$connector = connectors.connectors) !== null && _connectors$connector !== void 0 && _connectors$connector.length ? /*#__PURE__*/_react.default.createElement(_change_kb_model.ChangeKbModel, {
    knowledgeBase: knowledgeBase,
    productDoc: productDoc,
    currentlyDeployedInferenceId: currentlyDeployedInferenceId
  }) : undefined, /*#__PURE__*/_react.default.createElement(_ui_settings.UISettings, {
    knowledgeBase: knowledgeBase
  }));
}