"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsNavControlVisible = useIsNavControlVisible;
var _react = require("react");
var _rxjs = require("rxjs");
var _public = require("@kbn/core/public");
var _public2 = require("@kbn/ai-assistant-management-plugin/public");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function getVisibility(appId, applications, preferredAssistantType, space) {
  var _applications$get, _applications$get$cat;
  if (preferredAssistantType === _public2.AIAssistantType.Never) {
    return false;
  }
  const categoryId = appId && ((_applications$get = applications.get(appId)) === null || _applications$get === void 0 ? void 0 : (_applications$get$cat = _applications$get.category) === null || _applications$get$cat === void 0 ? void 0 : _applications$get$cat.id) || _public.DEFAULT_APP_CATEGORIES.kibana.id;
  if (preferredAssistantType === _public2.AIAssistantType.Observability || space.solution === 'es' || space.solution === 'oblt') {
    return categoryId !== _public.DEFAULT_APP_CATEGORIES.security.id;
  }
  return [_public.DEFAULT_APP_CATEGORIES.observability.id, _public.DEFAULT_APP_CATEGORIES.enterpriseSearch.id].includes(categoryId);
}
function useIsNavControlVisible({
  coreStart,
  pluginsStart
}) {
  const [isVisible, setIsVisible] = (0, _react.useState)(false);
  const {
    currentAppId$,
    applications$
  } = coreStart.application;
  const {
    aiAssistantManagementSelection,
    spaces
  } = pluginsStart;
  const space$ = spaces.getActiveSpace$();
  (0, _react.useEffect)(() => {
    const appSubscription = (0, _rxjs.combineLatest)([currentAppId$, applications$, aiAssistantManagementSelection.aiAssistantType$, space$]).subscribe({
      next: ([appId, applications, preferredAssistantType, space]) => {
        setIsVisible(getVisibility(appId, applications, preferredAssistantType, space));
      }
    });
    return () => appSubscription.unsubscribe();
  }, [currentAppId$, applications$, aiAssistantManagementSelection.aiAssistantType$, space$]);
  return {
    isVisible
  };
}