"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisPanel = RootCauseAnalysisPanel;
var _eui = require("@elastic/eui");
var _css = require("@emotion/css");
var _polished = require("polished");
var _react = _interopRequireDefault(require("react"));
var _use_theme = require("../../../hooks/use_theme");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisPanel({
  children,
  color
}) {
  const theme = (0, _use_theme.useTheme)();
  const isSeverityColor = color === 'risk' || color === 'neutral';
  const panelClassName = color && color !== 'transparent' && color !== 'plain' && color !== 'subdued' && color !== 'highlighted' ? (0, _css.css)`
          border: 1px solid;
          border-color: ${(0, _polished.rgba)(isSeverityColor ? theme.colors.severity[color] : theme.colors[color], 0.25)};
        ` : undefined;
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: true,
    paddingSize: "l",
    color: color,
    className: panelClassName
  }, children);
}