"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RootCauseAnalysisEntityInvestigation = RootCauseAnalysisEntityInvestigation;
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _react = _interopRequireDefault(require("react"));
var _entity_badge = require("../entity_badge");
var _rca_collapsible_panel = require("../rca_collapsible_panel");
var _rca_entity_log_pattern_table = require("../rca_entity_log_pattern_table");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function RootCauseAnalysisEntityInvestigation({
  summary,
  entity,
  ownPatterns,
  patternsFromOtherEntities
}) {
  return /*#__PURE__*/_react.default.createElement(_rca_collapsible_panel.RootCauseAnalysisCollapsiblePanel, {
    title: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "row",
      gutterSize: "s"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.observabilityAiAssistant.rootCauseAnalysisEntityInvestigation.title', {
      defaultMessage: 'Investigation'
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_entity_badge.EntityBadge, {
      entity: entity
    }))),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      direction: "column",
      gutterSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      color: "subdued",
      paddingSize: "l"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiMarkdownFormat, {
      textSize: "s"
    }, summary)), /*#__PURE__*/_react.default.createElement(_rca_entity_log_pattern_table.RootCauseAnalysisEntityLogPatternTable, {
      entity: entity,
      ownPatterns: ownPatterns,
      patternsFromOtherEntities: patternsFromOtherEntities
    }))
  });
}