"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Sparkline = void 0;
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _sparkline_flot_chart = require("./sparkline_flot_chart");
require("./sparkline.scss");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Sparkline extends _react.default.Component {
  constructor(props) {
    super(props);
    this.makeSparklineFlotChart = this.makeSparklineFlotChart.bind(this);
    this.onHover = this.onHover.bind(this);
    this.renderTooltip = this.renderTooltip.bind(this);
    this.handleSparklineRef = this.handleSparklineRef.bind(this);
    this.state = {
      tooltip: undefined
    };
  }
  UNSAFE_componentWillReceiveProps({
    series,
    options
  }) {
    if (!(0, _lodash.isEqual)(options, this.props.options)) {
      this.sparklineFlotChart.shutdown();
      this.makeSparklineFlotChart(options);
    }
    if (!(0, _lodash.isEqual)(series, this.props.series)) {
      this.sparklineFlotChart.update(series);
    }
  }
  makeSparklineFlotChart(overrideFlotOptions) {
    this.sparklineFlotChart = new _sparkline_flot_chart.SparklineFlotChart(this.chartElem, this.props.series, this.props.onBrush, this.onHover, overrideFlotOptions);
  }
  onHover(dataPoint) {
    this.setState({
      tooltip: dataPoint
    });
  }
  renderTooltip() {
    if (this.props.tooltip.enabled === false) {
      return;
    }
    if (!this.state.tooltip) {
      return;
    }
    const tooltipHeightInPx = 56;
    const tooltipWidthInPx = 220;
    const caretWidthInPx = 6;
    const marginBetweenPointAndCaretInPx = 10;
    const styles = {
      tooltipContainer: {
        top: this.state.tooltip.yPosition - tooltipHeightInPx / 2
      },
      tooltip: {
        height: tooltipHeightInPx,
        width: tooltipWidthInPx
      },
      leftCaret: {
        width: caretWidthInPx
      },
      rightCaret: {
        width: caretWidthInPx
      }
    };
    const plotMiddleX = this.state.tooltip.plotLeft + this.state.tooltip.plotWidth / 2;
    const tooltipContainerWidthInPx = tooltipWidthInPx + caretWidthInPx;
    if (this.state.tooltip.xPosition > plotMiddleX) {
      // The point is in the right half of the plot; position the tooltip
      // to the left of the point
      styles.rightCaret.display = 'block';
      styles.tooltipContainer.left = this.state.tooltip.xPosition - tooltipContainerWidthInPx - marginBetweenPointAndCaretInPx;
    } else {
      // The point is in the left half of the plot; position the tooltip
      // to the right of the point
      styles.leftCaret.display = 'block';
      styles.tooltipContainer.left = this.state.tooltip.xPosition + marginBetweenPointAndCaretInPx;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparklineTooltip__container",
      style: styles.tooltipContainer
    }, /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-caret-left monSparklineTooltip__caret",
      style: styles.leftCaret
    }), /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparklineTooltip",
      style: styles.tooltip
    }, /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparklineTooltip__yValue"
    }, this.props.tooltip.yValueFormatter(this.state.tooltip.yValue)), /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparklineTooltip__xValue"
    }, this.props.tooltip.xValueFormatter(this.state.tooltip.xValue))), /*#__PURE__*/_react.default.createElement("i", {
      className: "fa fa-caret-right monSparklineTooltip__caret",
      style: styles.rightCaret
    }));
  }
  handleSparklineRef(elem) {
    this.chartElem = elem;
    if (this.chartElem) {
      this.makeSparklineFlotChart(this.props.options);
    } else if (this.sparklineFlotChart) {
      this.sparklineFlotChart.shutdown();
    }
  }
  render() {
    return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("div", {
      className: "monSparkline",
      ref: this.handleSparklineRef
    }), this.renderTooltip());
  }
}
exports.Sparkline = Sparkline;
Sparkline.propTypes = {
  series: _propTypes.default.arrayOf(_propTypes.default.arrayOf(_propTypes.default.number)).isRequired,
  tooltip: _propTypes.default.shape({
    enabled: _propTypes.default.bool,
    xValueFormatter: _propTypes.default.func,
    yValueFormatter: _propTypes.default.func
  }),
  options: _propTypes.default.shape({
    xaxis: _propTypes.default.shape({
      min: _propTypes.default.number,
      max: _propTypes.default.number
    })
  })
};