"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.calculateClass = calculateClass;
var _lodash = require("lodash");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function calculateClass(item, initial) {
  const classes = [item.type];
  if (initial) {
    classes.push(initial);
  }
  if (item.type === 'shard') {
    classes.push('monShard');
    if ((0, _lodash.get)(item, 'shard.primary', item.primary)) {
      classes.push('primary');
    } else {
      classes.push('replica');
    }
    classes.push((0, _lodash.get)(item, 'shard.state', item.state).toLowerCase());
    if ((0, _lodash.get)(item, 'shard.state', item.state) === 'UNASSIGNED' && (0, _lodash.get)(item, 'shard.primary', item.primary)) {
      classes.push('emergency');
    }
  }
  if (item.master) {
    classes.push('master');
  }
  return classes.join(' ');
}