"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Unassigned = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _shard = require("./shard");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Unassigned extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createShard", shard => {
      const type = shard.primary ? 'primary' : 'replica';
      const additionId = shard.state === 'UNASSIGNED' ? Math.random() : '';
      const key = shard.index + '.' + shard.node + '.' + type + '.' + shard.state + '.' + shard.shard + additionId;
      return /*#__PURE__*/_react.default.createElement(_shard.Shard, {
        shard: shard,
        key: key
      });
    });
  }
  render() {
    const shards = (0, _lodash.sortBy)(this.props.shards, 'shard').map(this.createShard);
    return /*#__PURE__*/_react.default.createElement("td", {
      className: "monUnassigned",
      "data-test-subj": "clusterView-Unassigned"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      className: "monUnassigned__children"
    }, shards));
  }
}
exports.Unassigned = Unassigned;
(0, _defineProperty2.default)(Unassigned, "displayName", _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.unassignedDisplayName', {
  defaultMessage: 'Unassigned'
}));