"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TableBody = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireDefault(require("react"));
var _unassigned = require("./unassigned");
var _assigned = require("./assigned");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ShardRow = props => {
  let unassigned;
  if (props.data.unassigned && props.data.unassigned.length) {
    unassigned = /*#__PURE__*/_react.default.createElement(_unassigned.Unassigned, {
      shards: props.data.unassigned
    });
  } else {
    if (props.cols === 3) {
      unassigned = /*#__PURE__*/_react.default.createElement("td", null);
    }
  }
  return /*#__PURE__*/_react.default.createElement("tr", null, unassigned, /*#__PURE__*/_react.default.createElement(_assigned.Assigned, {
    shardStats: props.shardStats,
    data: props.data.children
  }));
};
class TableBody extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createRow", (data, index) => {
      return /*#__PURE__*/_react.default.createElement(ShardRow, (0, _extends2.default)({
        key: `shardRow-${index}`,
        data: data
      }, this.props));
    });
  }
  render() {
    if (this.props.totalCount === 0) {
      return /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", {
        colSpan: this.props.cols
      }, /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement("p", {
        style: {
          margin: '10px 0'
        },
        className: "text-center lead"
      }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
        id: "xpack.monitoring.elasticsearch.shardAllocation.tableBody.noShardsAllocatedDescription",
        defaultMessage: "There are no shards allocated."
      }))))));
    }
    if (this.props.shardStats) {
      if (this.props.rows.length) {
        return /*#__PURE__*/_react.default.createElement("tbody", null, this.props.rows.map(this.createRow));
      }
    }
    return /*#__PURE__*/_react.default.createElement("tbody", null, /*#__PURE__*/_react.default.createElement("tr", null, /*#__PURE__*/_react.default.createElement("td", {
      colSpan: this.props.cols
    })));
  }
}
exports.TableBody = TableBody;
(0, _defineProperty2.default)(TableBody, "displayName", _i18n.i18n.translate('xpack.monitoring.elasticsearch.shardAllocation.tableBodyDisplayName', {
  defaultMessage: 'TableBody'
}));