"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ClusterView = void 0;
var _react = _interopRequireDefault(require("react"));
var _table_head = require("./table_head");
var _table_body = require("./table_body");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ClusterView = props => {
  return /*#__PURE__*/_react.default.createElement("table", {
    cellPadding: "0",
    cellSpacing: "0",
    className: "table"
  }, /*#__PURE__*/_react.default.createElement(_table_head.TableHead, {
    labels: props.labels,
    toggleShowSystemIndices: props.toggleShowSystemIndices,
    showSystemIndices: props.showSystemIndices
  }), /*#__PURE__*/_react.default.createElement(_table_body.TableBody, {
    filter: props.filter,
    totalCount: props.totalCount,
    rows: props.nodesByIndices,
    cols: props.labels.length,
    shardStats: props.shardStats
  }));
};
exports.ClusterView = ClusterView;