"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Assigned = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _lodash = require("lodash");
var _react = _interopRequireDefault(require("react"));
var _shard = require("./shard");
var _calculate_class = require("../lib/calculate_class");
var _eui = require("@elastic/eui");
var _get_safe_for_external_link = require("../../../../lib/get_safe_for_external_link");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const generateQueryAndLink = data => {
  let type = 'indices';
  let ident = data.name;
  if (data.type === 'node') {
    type = 'nodes';
    ident = data.id;
  }
  return (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/${type}/${ident}`);
};
function sortByName(item) {
  if (item.type === 'node') {
    return [!item.master, item.name];
  }
  return [item.name];
}
class Assigned extends _react.default.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "createShard", shard => {
      const type = (0, _lodash.get)(shard, 'shard.primary', shard.primary) ? 'primary' : 'replica';
      const key = `${(0, _lodash.get)(shard, 'index.name', shard.index)}.${(0, _lodash.get)(shard, 'node.name', shard.node)}.${type}.${(0, _lodash.get)(shard, 'shard.state', shard.state)}.${(0, _lodash.get)(shard, 'shard.number', shard.shard)}`;
      return /*#__PURE__*/_react.default.createElement(_shard.Shard, {
        shard: shard,
        key: key
      });
    });
    (0, _defineProperty2.default)(this, "createChild", data => {
      const key = data.id;
      const initialClasses = ['monChild'];
      if (data.type === 'index') {
        initialClasses.push('monChild--index');
      }
      const shardStats = (0, _lodash.get)(this.props.shardStats.indices, key);
      if (shardStats) {
        switch (shardStats.status) {
          case 'red':
            initialClasses.push('monChild--danger');
            break;
          case 'yellow':
            initialClasses.push('monChild--warning');
            break;
        }
      }

      // TODO: redesign for shard allocation
      const name = /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
        href: generateQueryAndLink(data)
      }, data.name);
      const master = data.node_type === 'master' ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
        type: "starFilledSpace",
        color: "primary"
      }) : null;
      const shards = (0, _lodash.sortBy)(data.children, 'shard').map(this.createShard);
      return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        className: (0, _calculate_class.calculateClass)(data, initialClasses.join(' ')),
        key: key,
        "data-test-subj": `clusterView-Assigned-${key}`,
        "data-status": shardStats && shardStats.status
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        className: "monChild__title eui-textNoWrap"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "xs"
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, name), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false
      }, master))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        gutterSize: "s"
      }, shards))));
    });
  }
  render() {
    const data = (0, _lodash.sortBy)(this.props.data, sortByName).map(this.createChild);
    return /*#__PURE__*/_react.default.createElement("td", {
      className: "monAssigned"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      wrap: true,
      className: "monAssigned__children"
    }, data));
  }
}
exports.Assigned = Assigned;