"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ItemTemplate = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _page_template = require("../page_template");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ItemTemplate = props => {
  const {
    pageType,
    id,
    ...rest
  } = props;
  const tabs = [{
    id: 'overview',
    label: _i18n.i18n.translate('xpack.monitoring.esItemNavigation.overviewLinkText', {
      defaultMessage: 'Overview'
    }),
    route: `/elasticsearch/${pageType}/${id}`
  }, {
    id: 'advanced',
    testSubj: 'esItemDetailAdvancedLink',
    label: _i18n.i18n.translate('xpack.monitoring.esItemNavigation.advancedLinkText', {
      defaultMessage: 'Advanced'
    }),
    route: `/elasticsearch/${pageType}/${id}/advanced`
  }];
  return /*#__PURE__*/_react.default.createElement(_page_template.PageTemplate, (0, _extends2.default)({}, rest, {
    tabs: tabs,
    product: "elasticsearch"
  }));
};
exports.ItemTemplate = ItemTemplate;