"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
Object.defineProperty(exports, "CONSOLE_LANG_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_OUTPUT_LANG_ID", {
  enumerable: true,
  get: function () {
    return _constants.CONSOLE_OUTPUT_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_THEME_ID", {
  enumerable: true,
  get: function () {
    return _language.CONSOLE_THEME_ID;
  }
});
exports.ConsoleOutputLang = exports.ConsoleLang = exports.CONSOLE_TRIGGER_CHARS = void 0;
Object.defineProperty(exports, "ConsoleParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _console_parsed_requests_provider.ConsoleParsedRequestsProvider;
  }
});
Object.defineProperty(exports, "createOutputParser", {
  enumerable: true,
  get: function () {
    return _output_parser.createOutputParser;
  }
});
Object.defineProperty(exports, "getParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _language.getParsedRequestsProvider;
  }
});
var _esqlValidationAutocomplete = require("@kbn/esql-validation-autocomplete");
var _language = require("./language");
var _constants = require("./constants");
var _lexer_rules = require("./lexer_rules");
var _folding_range_provider = require("./folding_range_provider");
var _esql = require("../esql");
var _suggestions = require("../esql/lib/converters/suggestions");
var _utils = require("./utils");
var _console_parsed_requests_provider = require("./console_parsed_requests_provider");
var _output_parser = require("./output_parser");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

/**
 * This import registers the Console monaco language contribution
 */

/**
 * export the theme id for the console language
 */

const CONSOLE_TRIGGER_CHARS = exports.CONSOLE_TRIGGER_CHARS = ['/', '.', '_', ',', '?', '=', '&', '"'];
const ConsoleLang = exports.ConsoleLang = {
  ID: _constants.CONSOLE_LANG_ID,
  lexerRules: _lexer_rules.lexerRules,
  languageConfiguration: _lexer_rules.languageConfiguration,
  foldingRangeProvider: _folding_range_provider.foldingRangeProvider,
  getSuggestionProvider: (esqlCallbacks, actionsProvider) => {
    return {
      // force suggestions when these characters are used
      triggerCharacters: [...CONSOLE_TRIGGER_CHARS, ..._esql.ESQL_AUTOCOMPLETE_TRIGGER_CHARS],
      provideCompletionItems: async (model, position, context) => {
        const fullText = model.getValue();
        const cursorOffset = model.getOffsetAt(position);
        const textBeforeCursor = fullText.slice(0, cursorOffset);
        const {
          insideSingleQuotesQuery,
          insideTripleQuotesQuery,
          queryIndex
        } = (0, _utils.checkForTripleQuotesAndQueries)(textBeforeCursor);
        if (esqlCallbacks && (insideSingleQuotesQuery || insideTripleQuotesQuery)) {
          const queryText = textBeforeCursor.slice(queryIndex, cursorOffset);
          const unescapedQuery = (0, _utils.unescapeInvalidChars)(queryText);
          const esqlSuggestions = await (0, _esqlValidationAutocomplete.suggest)(unescapedQuery, unescapedQuery.length, context, esqlCallbacks);
          return {
            suggestions: (0, _suggestions.wrapAsMonacoSuggestions)(esqlSuggestions, queryText, false, insideSingleQuotesQuery)
          };
        } else if (actionsProvider.current) {
          var _actionsProvider$curr;
          return (_actionsProvider$curr = actionsProvider.current) === null || _actionsProvider$curr === void 0 ? void 0 : _actionsProvider$curr.provideCompletionItems(model, position, context);
        }
        return {
          suggestions: []
        };
      }
    };
  }
};
const ConsoleOutputLang = exports.ConsoleOutputLang = {
  ID: _constants.CONSOLE_OUTPUT_LANG_ID,
  lexerRules: _lexer_rules.consoleOutputLexerRules,
  languageConfiguration: _lexer_rules.consoleOutputLanguageConfiguration,
  foldingRangeProvider: _folding_range_provider.foldingRangeProvider
};