"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useAnomalyChartsData = useAnomalyChartsData;
var _react = require("react");
var _rxjs = require("rxjs");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _get_jobs_observable = require("../common/get_jobs_observable");
var _explorer_constants = require("../../application/explorer/explorer_constants");
var _process_filters = require("../common/process_filters");
var _explorer_utils = require("../../application/explorer/explorer_utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const FETCH_RESULTS_DEBOUNCE_MS = 500;
function useAnomalyChartsData(api, services, chartWidth, severity, renderCallbacks) {
  const [,, {
    anomalyDetectorService,
    anomalyExplorerService
  }] = services;
  const [chartsData, setChartsData] = (0, _react.useState)();
  const [error, setError] = (0, _react.useState)();
  const [isLoading, setIsLoading] = (0, _react.useState)(false);
  const chartWidth$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  const severity$ = (0, _react.useMemo)(() => new _rxjs.Subject(), []);
  (0, _react.useEffect)(() => {
    const subscription = (0, _rxjs.combineLatest)({
      explorerJobs: (0, _get_jobs_observable.getJobsObservable)(api.jobIds$, anomalyDetectorService, setError),
      maxSeriesToPlot: api.maxSeriesToPlot$,
      chartWidth: chartWidth$.pipe((0, _rxjs.skipWhile)(v => !v)),
      severityValue: severity$,
      dataPublishingServices: (0, _presentationPublishing.fetch$)(api)
    }).pipe((0, _rxjs.tap)(setIsLoading.bind(null, true)), (0, _rxjs.debounceTime)(FETCH_RESULTS_DEBOUNCE_MS), (0, _rxjs.tap)(() => {
      renderCallbacks.onLoading(true);
    }), (0, _rxjs.switchMap)(({
      explorerJobs,
      maxSeriesToPlot,
      chartWidth: embeddableContainerWidth,
      severityValue,
      dataPublishingServices
    }) => {
      var _bounds$min, _bounds$max;
      const {
        timeRange: timeRangeInput,
        filters,
        query
      } = dataPublishingServices;
      if (!explorerJobs) {
        // couldn't load the list of jobs
        return (0, _rxjs.of)(undefined);
      }
      const viewBySwimlaneFieldName = _explorer_constants.OVERALL_LABEL;
      if (timeRangeInput) {
        anomalyExplorerService.setTimeRange(timeRangeInput);
      }
      let influencersFilterQuery;
      try {
        if (filters || query) {
          influencersFilterQuery = (0, _process_filters.processFilters)(filters, query);
        }
      } catch (e) {
        // handle query syntax errors
        setError(e);
        return (0, _rxjs.of)(undefined);
      }
      const bounds = anomalyExplorerService.getTimeBounds();

      // Can be from input time range or from the timefilter bar
      const selections = {
        lanes: [_explorer_constants.OVERALL_LABEL],
        times: [(_bounds$min = bounds.min) === null || _bounds$min === void 0 ? void 0 : _bounds$min.unix(), (_bounds$max = bounds.max) === null || _bounds$max === void 0 ? void 0 : _bounds$max.unix()],
        type: _explorer_constants.SWIMLANE_TYPE.OVERALL
      };
      const selectionInfluencers = (0, _explorer_utils.getSelectionInfluencers)(selections, viewBySwimlaneFieldName);
      const jobIds = (0, _explorer_utils.getSelectionJobIds)(selections, explorerJobs);
      const timeRange = (0, _explorer_utils.getSelectionTimeRange)(selections, bounds);
      return anomalyExplorerService.getAnomalyData$(jobIds, embeddableContainerWidth, timeRange.earliestMs, timeRange.latestMs, influencersFilterQuery, selectionInfluencers, severityValue !== null && severityValue !== void 0 ? severityValue : 0, maxSeriesToPlot);
    }), (0, _rxjs.catchError)(e => {
      // eslint-disable-next-line no-console
      console.error(`Error occured fetching anomaly charts data for embeddable\n`, e);
      setError(e.body);
      return (0, _rxjs.of)(undefined);
    })).subscribe(results => {
      if (results !== undefined) {
        setError(null);
        setChartsData(results);
        setIsLoading(false);
        renderCallbacks.onRenderComplete();
      }
    });
    return () => {
      subscription === null || subscription === void 0 ? void 0 : subscription.unsubscribe();
      chartWidth$.complete();
      severity$.complete();
    };
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, []);
  (0, _react.useEffect)(() => {
    chartWidth$.next(chartWidth);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [chartWidth]);
  (0, _react.useEffect)(() => {
    severity$.next(severity);
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [severity]);
  (0, _react.useEffect)(() => {
    if (error) {
      renderCallbacks.onError(error);
    }
    // eslint-disable-next-line react-hooks/exhaustive-deps
  }, [error]);
  return {
    chartsData,
    isLoading,
    error
  };
}