"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimeseriesexplorerNoChartData = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/*
 * React component for rendering EuiEmptyPrompt when no results were found.
 */

const TimeseriesexplorerNoChartData = ({
  dataNotChartable,
  entities
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiEmptyPrompt, {
  iconType: "info",
  title: /*#__PURE__*/_react.default.createElement("h2", null, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.noResultsFoundLabel', {
    defaultMessage: 'No results found'
  })),
  body: dataNotChartable ? /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.dataNotChartableDescription', {
    defaultMessage: `Model plot is not collected for the selected {entityCount, plural, one {entity} other {entities}}
and the source data cannot be plotted for this detector.`,
    values: {
      entityCount: entities.length
    }
  })) : /*#__PURE__*/_react.default.createElement("p", null, _i18n.i18n.translate('xpack.ml.timeSeriesExplorer.tryWideningTheTimeSelectionDescription', {
    defaultMessage: 'Try widening the time selection or moving further back in time.'
  }))
});
exports.TimeseriesexplorerNoChartData = TimeseriesexplorerNoChartData;