"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CalendarForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _check_capabilities = require("../../../../capabilities/check_capabilities");
var _locator = require("../../../../../../common/constants/locator");
var _use_create_url = require("../../../../contexts/kibana/use_create_url");
var _page_header = require("../../../../components/page_header");
var _dst_event_generator = require("./dst_event_generator");
var _events_table = require("../events_table");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const EditHeader = ({
  calendarId,
  description
}) => {
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement("span", {
    "data-test-subj": 'mlCalendarTitle'
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.calendarTitle",
    defaultMessage: "Calendar {calendarId}",
    values: {
      calendarId
    }
  }))), description ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
    "data-test-subj": 'mlCalendarDescriptionText'
  }, /*#__PURE__*/_react.default.createElement("p", null, description)), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  })) : null);
};
const CalendarForm = ({
  calendarId,
  description,
  eventsList,
  groupIdOptions,
  isEdit,
  isNewCalendarIdValid,
  jobIdOptions,
  onCalendarIdChange,
  onCreate,
  onCreateGroupOption,
  onDescriptionChange,
  onEdit,
  onEventDelete,
  onGroupSelection,
  showImportModal,
  onJobSelection,
  saving,
  loading,
  selectedGroupOptions,
  selectedJobOptions,
  showNewEventModal,
  isGlobalCalendar,
  onGlobalCalendarChange,
  addEvents,
  clearEvents,
  isDst
}) => {
  const [canCreateCalendar] = (0, _check_capabilities.usePermissionCheck)(['canCreateCalendar']);
  const [timezone, setTimezone] = (0, _react.useState)(undefined);
  const msg = _i18n.i18n.translate('xpack.ml.calendarsEdit.calendarForm.allowedCharactersDescription', {
    defaultMessage: 'Use lowercase alphanumerics (a-z and 0-9), hyphens or underscores; ' + 'must start and end with an alphanumeric character'
  });
  const helpText = isNewCalendarIdValid === true && !isEdit ? msg : undefined;
  const error = isNewCalendarIdValid === false && !isEdit ? [msg] : undefined;
  const saveButtonDisabled = canCreateCalendar === false || saving || !isNewCalendarIdValid || calendarId === '' || loading === true || isDst && eventsList.length === 0;
  const redirectToCalendarsManagementPage = (0, _use_create_url.useCreateAndNavigateToMlLink)(isDst ? _locator.ML_PAGES.CALENDARS_DST_MANAGE : _locator.ML_PAGES.CALENDARS_MANAGE);
  const addDstEvents = (0, _react.useCallback)(events => {
    clearEvents();
    addEvents(events);
  }, [addEvents, clearEvents]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    "data-test-subj": `mlCalendarForm${isEdit === true ? 'Edit' : 'New'}`
  }, isEdit === true ? /*#__PURE__*/_react.default.createElement(EditHeader, {
    calendarId: calendarId,
    description: description
  }) : /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, isDst ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.createCalendarDstTitle",
    defaultMessage: "Create new DST calendar"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.createCalendarTitle",
    defaultMessage: "Create new calendar"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.calendarIdLabel",
      defaultMessage: "Calendar ID"
    }),
    helpText: helpText,
    error: error,
    isInvalid: !isNewCalendarIdValid
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "calendarId",
    value: calendarId,
    onChange: onCalendarIdChange,
    disabled: saving === true || loading === true,
    "data-test-subj": "mlCalendarIdInput"
  })), isDst === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.descriptionLabel",
      defaultMessage: "Description"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    name: "description",
    value: description,
    onChange: onDescriptionChange,
    disabled: saving === true || loading === true,
    "data-test-subj": "mlCalendarDescriptionInput"
  })) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })), isDst === false ? /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    name: "switch",
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.allJobsLabel",
      defaultMessage: "Apply calendar to all jobs"
    }),
    checked: isGlobalCalendar,
    onChange: onGlobalCalendarChange,
    disabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarApplyToAllJobsSwitch"
  }) : null, isGlobalCalendar === false ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.jobsLabel",
      defaultMessage: "Jobs"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    options: jobIdOptions,
    selectedOptions: selectedJobOptions,
    onChange: onJobSelection,
    isDisabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarJobSelection"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.groupsLabel",
      defaultMessage: "Groups"
    })
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiComboBox, {
    onCreateOption: onCreateGroupOption,
    options: groupIdOptions,
    selectedOptions: selectedGroupOptions,
    onChange: onGroupSelection,
    isDisabled: saving === true || canCreateCalendar === false || loading === true,
    "data-test-subj": "mlCalendarJobGroupSelection"
  }))) : null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "xl"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: isDst ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.dstEventsLabel",
      defaultMessage: "Time zone of data"
    }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.calendarsEdit.calendarForm.eventsLabel",
      defaultMessage: "Events"
    }),
    fullWidth: true
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, isDst ? /*#__PURE__*/_react.default.createElement(_dst_event_generator.DstEventGenerator, {
    addEvents: addDstEvents,
    setTimezone: setTimezone,
    isDisabled: saving === true || canCreateCalendar === false || loading === true
  }) : null, /*#__PURE__*/_react.default.createElement(_events_table.EventsTable, {
    eventsList: eventsList,
    onDeleteClick: onEventDelete,
    showImportModal: showImportModal,
    showNewEventModal: showNewEventModal,
    loading: loading,
    saving: saving,
    showSearchBar: isDst === false,
    timezone: timezone,
    isDst: isDst
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "l"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    justifyContent: "flexEnd"
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    isDisabled: saving,
    onClick: redirectToCalendarsManagementPage
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.cancelButtonLabel",
    defaultMessage: "Cancel"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
    "data-test-subj": "mlSaveCalendarButton",
    fill: true,
    onClick: isEdit ? onEdit : onCreate,
    isDisabled: saveButtonDisabled
  }, saving ? /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.savingButtonLabel",
    defaultMessage: "Saving\u2026"
  }) : /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.calendarsEdit.calendarForm.saveButtonLabel",
    defaultMessage: "Save"
  })))));
};
exports.CalendarForm = CalendarForm;