"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.modelsListRouteFactory = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxUtility = require("@kbn/shared-ux-utility");
var _locator = require("../../../../locator");
var _router = require("../../router");
var _use_resolver = require("../../use_resolver");
var _resolvers = require("../../resolvers");
var _breadcrumbs = require("../../breadcrumbs");
var _page_header = require("../../../components/page_header");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
const ModelsList = (0, _sharedUxUtility.dynamic)(async () => ({
  default: (await Promise.resolve().then(() => _interopRequireWildcard(require('../../../model_management/models_list')))).ModelsList
}));
const modelsListRouteFactory = (navigateToPath, basePath) => ({
  id: 'trained_models',
  path: (0, _router.createPath)(_locator.ML_PAGES.TRAINED_MODELS_MANAGE),
  title: _i18n.i18n.translate('xpack.ml.modelManagement.trainedModels.docTitle', {
    defaultMessage: 'Trained Models'
  }),
  render: () => /*#__PURE__*/_react.default.createElement(PageWrapper, null),
  breadcrumbs: [(0, _breadcrumbs.getBreadcrumbWithUrlForApp)('ML_BREADCRUMB', navigateToPath, basePath), (0, _breadcrumbs.getBreadcrumbWithUrlForApp)('TRAINED_MODELS', navigateToPath, basePath), {
    text: _i18n.i18n.translate('xpack.ml.trainedModelsBreadcrumbs.trainedModelsLabel', {
      defaultMessage: 'Trained Models'
    })
  }],
  enableDatePicker: true,
  'data-test-subj': 'mlPageModelManagement'
});
exports.modelsListRouteFactory = modelsListRouteFactory;
const PageWrapper = () => {
  const {
    context
  } = (0, _use_resolver.useRouteResolver)('full', ['canGetTrainedModels'], {
    ...(0, _resolvers.basicResolvers)(),
    initSavedObjects: _resolvers.initSavedObjects
  });
  return /*#__PURE__*/_react.default.createElement(_router.PageLoader, {
    context: context
  }, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    responsive: false,
    wrap: false,
    alignItems: 'center',
    gutterSize: 'm'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.modelManagement.trainedModelsHeader",
    defaultMessage: "Trained Models"
  })))), /*#__PURE__*/_react.default.createElement(ModelsList, null));
};