"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getBreadcrumbWithUrlForApp = exports.breadcrumbOnClickFactory = exports.TRAINED_MODELS = exports.SUPPLIED_CONFIGURATIONS = exports.SETTINGS_BREADCRUMB = exports.ML_BREADCRUMB = exports.LOG_RATE_ANALYSIS = exports.LOG_PATTERN_ANALYSIS = exports.FILTER_LISTS_BREADCRUMB = exports.DATA_VISUALIZER_BREADCRUMB = exports.DATA_FRAME_ANALYTICS_BREADCRUMB = exports.DATA_DRIFT_BREADCRUMB = exports.CREATE_JOB_BREADCRUMB = exports.CHANGE_POINT_DETECTION = exports.CALENDAR_MANAGEMENT_BREADCRUMB = exports.CALENDAR_DST_MANAGEMENT_BREADCRUMB = exports.ANOMALY_DETECTION_BREADCRUMB = exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = void 0;
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ML_BREADCRUMB = exports.ML_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.machineLearningBreadcrumbLabel', {
    defaultMessage: 'Machine Learning'
  }),
  href: '/'
});
const SETTINGS_BREADCRUMB = exports.SETTINGS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settingsBreadcrumbLabel', {
    defaultMessage: 'Settings'
  }),
  href: '/settings',
  deepLinkId: 'ml:settings'
});
const ANOMALY_DETECTION_BREADCRUMB = exports.ANOMALY_DETECTION_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.anomalyDetectionBreadcrumbLabel', {
    defaultMessage: 'Anomaly Detection'
  }),
  href: '/jobs',
  deepLinkId: 'ml:anomalyDetection'
});
const DATA_FRAME_ANALYTICS_BREADCRUMB = exports.DATA_FRAME_ANALYTICS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.dataFrameAnalyticsLabel', {
    defaultMessage: 'Data Frame Analytics'
  }),
  href: '/data_frame_analytics',
  deepLinkId: 'ml:dataFrameAnalytics'
});
const TRAINED_MODELS = exports.TRAINED_MODELS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.modelManagementLabel', {
    defaultMessage: 'Model Management'
  }),
  href: '/trained_models',
  deepLinkId: 'ml:modelManagement'
});
const SUPPLIED_CONFIGURATIONS = exports.SUPPLIED_CONFIGURATIONS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.suppliedConfigurationsLabel', {
    defaultMessage: 'Supplied configurations'
  }),
  href: '/supplied_configurations',
  deepLinkId: 'ml:suppliedConfigurations'
});
const DATA_VISUALIZER_BREADCRUMB = exports.DATA_VISUALIZER_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.datavisualizerBreadcrumbLabel', {
    defaultMessage: 'Data Visualizer'
  }),
  href: '/datavisualizer',
  deepLinkId: 'ml:dataVisualizer'
});

// we need multiple AIOPS_BREADCRUMB breadcrumb items as they each need to link
// to each of the AIOps pages.
const AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_rate_analysis_index_select'
});
const AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = exports.AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/log_categorization_index_select'
});
const AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = exports.AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiopsBreadcrumbLabel', {
    defaultMessage: 'AIOps Labs'
  }),
  href: '/aiops/change_point_detection_index_select'
});
const LOG_RATE_ANALYSIS = exports.LOG_RATE_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logRateAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log Rate Analysis'
  }),
  href: '/aiops/log_rate_analysis_index_select',
  deepLinkId: 'ml:logRateAnalysis'
});
const LOG_PATTERN_ANALYSIS = exports.LOG_PATTERN_ANALYSIS = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.logPatternAnalysisBreadcrumbLabel', {
    defaultMessage: 'Log Pattern Analysis'
  }),
  href: '/aiops/log_categorization_index_select',
  deepLinkId: 'ml:logPatternAnalysis'
});
const CHANGE_POINT_DETECTION = exports.CHANGE_POINT_DETECTION = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.aiops.changePointDetectionBreadcrumbLabel', {
    defaultMessage: 'Change Point Detection'
  }),
  href: '/aiops/change_point_detection_index_select',
  deepLinkId: 'ml:changePointDetections'
});
const CREATE_JOB_BREADCRUMB = exports.CREATE_JOB_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.createJobsBreadcrumbLabel', {
    defaultMessage: 'Create job'
  }),
  href: '/jobs/new_job'
});
const CALENDAR_MANAGEMENT_BREADCRUMB = exports.CALENDAR_MANAGEMENT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagementLabel', {
    defaultMessage: 'Calendar management'
  }),
  href: '/settings/calendars_list',
  deepLinkId: 'ml:calendarSettings'
});
const CALENDAR_DST_MANAGEMENT_BREADCRUMB = exports.CALENDAR_DST_MANAGEMENT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.calendarManagementLabel', {
    defaultMessage: 'Calendar DST management'
  }),
  href: '/settings/calendars_dst_list',
  deepLinkId: 'ml:calendarSettings'
});
const FILTER_LISTS_BREADCRUMB = exports.FILTER_LISTS_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.filterListsLabel', {
    defaultMessage: 'Filter lists'
  }),
  href: '/settings/filter_lists',
  deepLinkId: 'ml:filterListsSettings'
});
const DATA_DRIFT_BREADCRUMB = exports.DATA_DRIFT_BREADCRUMB = Object.freeze({
  text: _i18n.i18n.translate('xpack.ml.settings.breadcrumbs.dataComparisonLabel', {
    defaultMessage: 'Data drift'
  }),
  href: '/data_drift_index_select',
  deepLinkId: 'ml:dataDrift'
});
const breadcrumbs = {
  ML_BREADCRUMB,
  SETTINGS_BREADCRUMB,
  ANOMALY_DETECTION_BREADCRUMB,
  DATA_FRAME_ANALYTICS_BREADCRUMB,
  TRAINED_MODELS,
  DATA_DRIFT_BREADCRUMB,
  DATA_VISUALIZER_BREADCRUMB,
  AIOPS_BREADCRUMB_LOG_RATE_ANALYSIS,
  AIOPS_BREADCRUMB_LOG_PATTERN_ANALYSIS,
  AIOPS_BREADCRUMB_CHANGE_POINT_DETECTION,
  LOG_RATE_ANALYSIS,
  LOG_PATTERN_ANALYSIS,
  CHANGE_POINT_DETECTION,
  CREATE_JOB_BREADCRUMB,
  CALENDAR_MANAGEMENT_BREADCRUMB,
  CALENDAR_DST_MANAGEMENT_BREADCRUMB,
  FILTER_LISTS_BREADCRUMB,
  SUPPLIED_CONFIGURATIONS
};
const breadcrumbOnClickFactory = (path, navigateToPath) => {
  return e => {
    e.preventDefault();
    navigateToPath(path);
  };
};
exports.breadcrumbOnClickFactory = breadcrumbOnClickFactory;
const getBreadcrumbWithUrlForApp = (breadcrumbName, navigateToPath, basePath) => {
  return {
    text: breadcrumbs[breadcrumbName].text,
    ...(navigateToPath ? {
      href: `${basePath}/app/ml${breadcrumbs[breadcrumbName].href}`,
      deepLinkId: breadcrumbs[breadcrumbName].deepLinkId,
      onClick: breadcrumbOnClickFactory(breadcrumbs[breadcrumbName].href, navigateToPath)
    } : {})
  };
};
exports.getBreadcrumbWithUrlForApp = getBreadcrumbWithUrlForApp;