"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.overviewPanelDefaultState = exports.default = exports.OverviewPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _mlDatePicker = require("@kbn/ml-date-picker");
var _mlLocalStorage = require("@kbn/ml-local-storage");
var _collapsible_panel = require("../components/collapsible_panel/collapsible_panel");
var _locator = require("../../../common/constants/locator");
var _storage = require("../../../common/types/storage");
var _collapsible_panel2 = require("../components/collapsible_panel");
var _check_capabilities = require("../capabilities/check_capabilities");
var _ml_nodes_check = require("../ml_nodes_check");
var _content = require("./components/content");
var _node_available_warning = require("../components/node_available_warning");
var _jobs_awaiting_node_warning = require("../components/jobs_awaiting_node_warning");
var _saved_objects_warning = require("../components/saved_objects_warning");
var _upgrade = require("../components/upgrade");
var _help_menu = require("../components/help_menu");
var _kibana = require("../contexts/kibana");
var _nodes_overview = require("../memory_usage/nodes_overview");
var _page_header = require("../components/page_header");
var _page_title = require("../components/page_title");
var _check_ml_nodes = require("../ml_nodes_check/check_ml_nodes");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const overviewPanelDefaultState = exports.overviewPanelDefaultState = Object.freeze({
  nodes: true,
  adJobs: true,
  dfaJobs: true
});
const OverviewPage = () => {
  const [canViewMlNodes, canCreateJob] = (0, _check_capabilities.usePermissionCheck)(['canViewMlNodes', 'canCreateJob']);
  const disableCreateAnomalyDetectionJob = !canCreateJob || !(0, _ml_nodes_check.mlNodesAvailable)();
  const {
    services: {
      docLinks
    }
  } = (0, _kibana.useMlKibana)();
  const helpLink = docLinks.links.ml.guide;
  const viewNodesLink = (0, _kibana.useMlLink)({
    page: _locator.ML_PAGES.MEMORY_USAGE
  });
  const timefilter = (0, _mlDatePicker.useTimefilter)({
    timeRangeSelector: true,
    autoRefreshSelector: true
  });
  const [adLazyJobCount, setAdLazyJobCount] = (0, _react.useState)(0);
  const [dfaLazyJobCount, setDfaLazyJobCount] = (0, _react.useState)(0);
  const [panelsState, setPanelsState] = (0, _mlLocalStorage.useStorage)(_storage.ML_OVERVIEW_PANELS, overviewPanelDefaultState);
  return /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_page_header.MlPageHeader, null, /*#__PURE__*/_react.default.createElement(_page_title.PageTitle, {
    title: _i18n.i18n.translate('xpack.ml.overview.overviewLabel', {
      defaultMessage: 'Overview'
    })
  })), /*#__PURE__*/_react.default.createElement(_node_available_warning.NodeAvailableWarning, null), /*#__PURE__*/_react.default.createElement(_jobs_awaiting_node_warning.JobsAwaitingNodeWarning, {
    jobCount: adLazyJobCount + dfaLazyJobCount
  }), /*#__PURE__*/_react.default.createElement(_saved_objects_warning.SavedObjectsWarning, {
    onCloseFlyout: () => {
      const {
        from,
        to
      } = timefilter.getTime();
      const timeRange = {
        start: from,
        end: to
      };
      _mlDatePicker.mlTimefilterRefresh$.next({
        lastRefresh: Date.now(),
        timeRange
      });
    }
  }), /*#__PURE__*/_react.default.createElement(_upgrade.UpgradeWarning, null), canViewMlNodes ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_collapsible_panel2.CollapsiblePanel, {
    isOpen: panelsState.nodes,
    onToggle: update => {
      setPanelsState({
        ...panelsState,
        nodes: update
      });
    },
    header: /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.overview.nodesPanel.header",
      defaultMessage: "Nodes"
    }),
    headerItems: [/*#__PURE__*/_react.default.createElement(_collapsible_panel.OverviewStatsBar, {
      inputStats: [{
        label: _i18n.i18n.translate('xpack.ml.overview.nodesPanel.totalNodesLabel', {
          defaultMessage: 'Total'
        }),
        value: (0, _check_ml_nodes.getMlNodesCount)(),
        'data-test-subj': 'mlTotalNodesCount'
      }],
      dataTestSub: 'mlOverviewAnalyticsStatsBar'
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      href: viewNodesLink
    }, _i18n.i18n.translate('xpack.ml.overview.nodesPanel.viewNodeLink', {
      defaultMessage: 'View nodes'
    }))],
    ariaLabel: _i18n.i18n.translate('xpack.ml.overview.nodesPanel.ariaLabel', {
      defaultMessage: 'Nodes panel'
    })
  }, /*#__PURE__*/_react.default.createElement(_nodes_overview.NodesList, {
    compactView: true
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  })) : null, /*#__PURE__*/_react.default.createElement(_content.OverviewContent, {
    createAnomalyDetectionJobDisabled: disableCreateAnomalyDetectionJob,
    setAdLazyJobCount: setAdLazyJobCount,
    setDfaLazyJobCount: setDfaLazyJobCount
  }), /*#__PURE__*/_react.default.createElement(_help_menu.HelpMenu, {
    docLink: helpLink
  }));
};

// required for dynamic import using React.lazy()
// eslint-disable-next-line import/no-default-export
exports.OverviewPage = OverviewPage;
var _default = exports.default = OverviewPage;