"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextInputForm = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useObservable = _interopRequireDefault(require("react-use/lib/useObservable"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _mlErrorUtils = require("@kbn/ml-error-utils");
var _inference_error = require("../../inference_error");
var _output_loading = require("../../output_loading");
var _inference_base = require("../inference_base");
var _raw_output = require("../raw_output");
var _input_form_controls = require("./input_form_controls");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
var TAB = /*#__PURE__*/function (TAB) {
  TAB[TAB["TEXT"] = 0] = "TEXT";
  TAB[TAB["RAW"] = 1] = "RAW";
  return TAB;
}(TAB || {});
const TextInputForm = ({
  inferrer
}) => {
  const [selectedTab, setSelectedTab] = (0, _react.useState)(TAB.TEXT);
  const [errorText, setErrorText] = (0, _react.useState)(null);
  const isValid = (0, _useObservable.default)(inferrer.getIsValid$(), inferrer.getIsValid());
  const runningState = (0, _useObservable.default)(inferrer.getRunningState$(), inferrer.getRunningState());
  const inputComponent = (0, _react.useMemo)(() => inferrer.getInputComponent(), [inferrer]);
  const outputComponent = (0, _react.useMemo)(() => inferrer.getOutputComponent(), [inferrer]);
  const infoComponent = (0, _react.useMemo)(() => inferrer.getInfoComponent(), [inferrer]);
  const run = (0, _react.useCallback)(async event => {
    event.preventDefault();
    setErrorText(null);
    try {
      await inferrer.infer();
    } catch (e) {
      setErrorText((0, _mlErrorUtils.extractErrorMessage)(e));
    }
  }, [inferrer]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: 'form',
    onSubmit: run
  }, /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, infoComponent), /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, inputComponent), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement("div", null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_input_form_controls.InputFormControls, {
    testButtonDisabled: runningState === _inference_base.RUNNING_STATE.RUNNING || isValid === false,
    createPipelineButtonDisabled: runningState === _inference_base.RUNNING_STATE.RUNNING || isValid === false,
    inferrer: inferrer
  }))), runningState !== _inference_base.RUNNING_STATE.STOPPED ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiTabs, {
    size: 's'
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.TEXT,
    onClick: setSelectedTab.bind(null, TAB.TEXT)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.markupTab",
    defaultMessage: "Output"
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiTab, {
    isSelected: selectedTab === TAB.RAW,
    onClick: setSelectedTab.bind(null, TAB.RAW)
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.trainedModels.testModelsFlyout.inferenceInputForm.rawOutput",
    defaultMessage: "Raw output"
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "m"
  }), selectedTab === TAB.TEXT ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, runningState === _inference_base.RUNNING_STATE.RUNNING ? /*#__PURE__*/_react.default.createElement(_output_loading.OutputLoadingContent, {
    text: ''
  }) : null, errorText !== null || runningState === _inference_base.RUNNING_STATE.FINISHED_WITH_ERRORS ? /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_inference_error.ErrorMessage, {
    errorText: errorText
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, null)) : null, runningState === _inference_base.RUNNING_STATE.FINISHED ? /*#__PURE__*/_react.default.createElement("div", {
    "data-test-subj": 'mlTestModelOutput'
  }, outputComponent) : null) : /*#__PURE__*/_react.default.createElement(_raw_output.RawOutput, {
    inferrer: inferrer
  })) : null);
};
exports.TextInputForm = TextInputForm;