"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.PipelineDetails = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
var _codeEditor = require("@kbn/code-editor");
var _constants = require("../../components/ml_inference/constants");
var _validation_utils = require("../../../../common/util/validation_utils");
var _test_trained_models_context = require("../test_models/test_trained_models_context");
var _save_changes_button = require("../../components/ml_inference/components/save_changes_button");
var _validation = require("../../components/ml_inference/validation");
var _shared = require("../../components/shared");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const PipelineDetails = exports.PipelineDetails = /*#__PURE__*/(0, _react.memo)(({
  handlePipelineConfigUpdate,
  modelId,
  pipelineName,
  pipelineNameError,
  pipelineDescription,
  initialPipelineConfig,
  setHasUnsavedChanges,
  taskType
}) => {
  const [isProcessorConfigValid, setIsProcessorConfigValid] = (0, _react.useState)(true);
  const [processorConfigError, setProcessorConfigError] = (0, _react.useState)();
  const {
    currentContext: {
      pipelineConfig
    }
  } = (0, _test_trained_models_context.useTestTrainedModelsContext)();
  const [processorConfigString, setProcessorConfigString] = (0, _react.useState)(JSON.stringify(initialPipelineConfig !== null && initialPipelineConfig !== void 0 ? initialPipelineConfig : {}, null, 2));
  const [editProcessorConfig, setEditProcessorConfig] = (0, _react.useState)(false);
  const updateProcessorConfig = () => {
    const invalidProcessorConfigMessage = (0, _validation.validatePipelineProcessors)(JSON.parse(processorConfigString), taskType);
    if (invalidProcessorConfigMessage === undefined) {
      handlePipelineConfigUpdate({
        initialPipelineConfig: JSON.parse(processorConfigString)
      });
      setHasUnsavedChanges(false);
      setEditProcessorConfig(false);
      setProcessorConfigError(undefined);
    } else {
      setHasUnsavedChanges(true);
      setIsProcessorConfigValid(false);
      setProcessorConfigError(invalidProcessorConfigMessage);
    }
  };
  const handleProcessorConfigChange = json => {
    setProcessorConfigString(json);
    const valid = (0, _validation_utils.isValidJson)(json);
    setIsProcessorConfigValid(valid);
  };
  const resetProcessorConfig = () => {
    setProcessorConfigString(JSON.stringify(pipelineConfig, null, 2));
    setIsProcessorConfigValid(true);
    setProcessorConfigError(undefined);
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 3
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineDetailsTitle, {
    modelId: modelId
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: 7
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    hasBorder: false,
    hasShadow: false
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiForm, {
    component: "form"
  }, /*#__PURE__*/_react.default.createElement(_shared.PipelineNameAndDescription, {
    pipelineName: pipelineName,
    pipelineDescription: pipelineDescription,
    pipelineNameError: pipelineNameError,
    handlePipelineConfigUpdate: handlePipelineConfigUpdate
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    fullWidth: true,
    labelAppend: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "xs",
      alignItems: "center"
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditButton",
      iconType: "pencil",
      size: "xs",
      onClick: () => {
        const editingState = !editProcessorConfig;
        if (editingState === false) {
          setProcessorConfigError(undefined);
          setIsProcessorConfigValid(true);
          setHasUnsavedChanges(false);
        }
        setEditProcessorConfig(editingState);
      }
    }, editProcessorConfig ? _constants.CANCEL_EDIT_MESSAGE : _constants.EDIT_MESSAGE)), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_save_changes_button.SaveChangesButton, {
      onClick: updateProcessorConfig,
      disabled: isProcessorConfigValid === false
    }) : null), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false
    }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      size: "xs",
      onClick: resetProcessorConfig
    }, _i18n.i18n.translate('xpack.ml.trainedModels.content.indices.pipelines.addInferencePipelineModal.steps.advanced.resetInferenceConfigButton', {
      defaultMessage: 'Reset'
    })) : null)),
    error: processorConfigError,
    isInvalid: processorConfigError !== undefined,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigEditor"
  }, editProcessorConfig ? /*#__PURE__*/_react.default.createElement(_codeEditor.CodeEditor, {
    height: 300,
    languageId: "json",
    options: {
      automaticLayout: true,
      lineNumbers: 'off',
      tabSize: 2
    },
    value: processorConfigString,
    onChange: handleProcessorConfigChange
  }) : /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    isCopyable: true,
    "data-test-subj": "mlTrainedModelsInferencePipelineInferenceConfigBlock"
  }, processorConfigString))))));
});