"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RareInPopulationCard = exports.RareCard = exports.FrequentlyRareInPopulationCard = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RareCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rareCard.title', {
    defaultMessage: 'Rare'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rareCard.description",
    defaultMessage: "Find rare values over time."
  })),
  selectable: {
    onClick,
    isSelected
  }
}));
exports.RareCard = RareCard;
const RareInPopulationCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rarePopulationCard.title', {
    defaultMessage: 'Rare in population'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.rarePopulationCard.description",
    defaultMessage: "Find members of a population that have rare values over time."
  })),
  selectable: {
    onClick,
    isSelected
  }
}));
exports.RareInPopulationCard = RareInPopulationCard;
const FrequentlyRareInPopulationCard = ({
  onClick,
  isSelected
}) => /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
  "data-test-subj": `mlJobWizardCategorizationDetectorRareCard${isSelected ? ' selected' : ''}`,
  title: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.freqRareCard.title', {
    defaultMessage: 'Frequently rare in population'
  }),
  description: /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.ml.newJob.wizard.pickFieldsStep.rareDetectorSelect.freqRareCard.description",
    defaultMessage: "Find members of a population that frequently have rare values."
  })),
  selectable: {
    onClick,
    isSelected
  }
}));
exports.FrequentlyRareInPopulationCard = FrequentlyRareInPopulationCard;