"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.BucketSpanInput = void 0;
var _react = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const BucketSpanInput = ({
  bucketSpan,
  setBucketSpan,
  isInvalid,
  disabled
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
    disabled: disabled,
    placeholder: _i18n.i18n.translate('xpack.ml.newJob.wizard.pickFieldsStep.bucketSpan.placeholder', {
      defaultMessage: 'Bucket span'
    }),
    value: bucketSpan,
    onChange: e => setBucketSpan(e.target.value),
    isInvalid: isInvalid,
    "data-test-subj": "mlJobWizardInputBucketSpan"
  });
};
exports.BucketSpanInput = BucketSpanInput;