"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getJobsItemsFromEmbeddable = getJobsItemsFromEmbeddable;
exports.isCompatibleMapVisualization = isCompatibleMapVisualization;
exports.redirectToGeoJobWizard = redirectToGeoJobWizard;
var _i18n = require("@kbn/i18n");
var _presentationPublishing = require("@kbn/presentation-publishing");
var _locator = require("../../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function redirectToGeoJobWizard(embeddable, dataViewId, geoField, layerQuery, splitField, share) {
  var _embeddable$query$, _embeddable$filters$$, _embeddable$filters$;
  const {
    query,
    filters,
    to,
    from
  } = await getJobsItemsFromEmbeddable(embeddable);
  const embeddableQuery = (_embeddable$query$ = embeddable.query$) === null || _embeddable$query$ === void 0 ? void 0 : _embeddable$query$.value;
  const embeddableFilters = (_embeddable$filters$$ = (_embeddable$filters$ = embeddable.filters$) === null || _embeddable$filters$ === void 0 ? void 0 : _embeddable$filters$.value) !== null && _embeddable$filters$$ !== void 0 ? _embeddable$filters$$ : [];
  const locator = share.url.locators.get(_locator.ML_APP_LOCATOR);
  const pageState = {
    dashboard: {
      query,
      filters
    },
    dataViewId,
    embeddable: {
      query: embeddableQuery,
      filters: embeddableFilters
    },
    geoField,
    splitField,
    from,
    to,
    ...(layerQuery ? {
      layer: {
        query: layerQuery
      }
    } : {})
  };
  const url = await (locator === null || locator === void 0 ? void 0 : locator.getUrl({
    page: _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_FROM_MAP,
    pageState
  }));
  window.open(url, '_blank');
}
function isCompatibleMapVisualization(api) {
  return api.getLayerList().some(layer => {
    return layer.getGeoFieldNames().length && layer.getIndexPatternIds().length;
  });
}
async function getJobsItemsFromEmbeddable(embeddable) {
  var _embeddable$timeRange, _embeddable$timeRange2, _dashboardApi$timeRan, _ref, _dashboardApi$query$, _dashboardApi$filters, _dashboardApi$filters2;
  const dashboardApi = (0, _presentationPublishing.apiIsOfType)(embeddable.parentApi, 'dashboard') ? embeddable.parentApi : undefined;
  const timeRange = (_embeddable$timeRange = (_embeddable$timeRange2 = embeddable.timeRange$) === null || _embeddable$timeRange2 === void 0 ? void 0 : _embeddable$timeRange2.value) !== null && _embeddable$timeRange !== void 0 ? _embeddable$timeRange : dashboardApi === null || dashboardApi === void 0 ? void 0 : (_dashboardApi$timeRan = dashboardApi.timeRange$) === null || _dashboardApi$timeRan === void 0 ? void 0 : _dashboardApi$timeRan.value;
  if (timeRange === undefined) {
    throw Error(_i18n.i18n.translate('xpack.ml.newJob.fromGeo.createJob.error.noTimeRange', {
      defaultMessage: 'Time range not specified.'
    }));
  }
  return {
    from: timeRange.from,
    to: timeRange.to,
    query: (_ref = dashboardApi === null || dashboardApi === void 0 ? void 0 : (_dashboardApi$query$ = dashboardApi.query$) === null || _dashboardApi$query$ === void 0 ? void 0 : _dashboardApi$query$.value) !== null && _ref !== void 0 ? _ref : {
      query: '',
      language: 'kuery'
    },
    filters: (_dashboardApi$filters = dashboardApi === null || dashboardApi === void 0 ? void 0 : (_dashboardApi$filters2 = dashboardApi.filters$) === null || _dashboardApi$filters2 === void 0 ? void 0 : _dashboardApi$filters2.value) !== null && _dashboardApi$filters !== void 0 ? _dashboardApi$filters : [],
    dashboard: dashboardApi
  };
}