"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.JsonPane = JsonPane;
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _ml_job_editor = require("../ml_job_editor");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function JsonPane({
  job
}) {
  const json = JSON.stringify(job, null, 2);
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_ml_job_editor.MLJobEditor, {
    value: json,
    readOnly: true,
    mode: _ml_job_editor.ML_EDITOR_MODE.XJSON
  }));
}
JsonPane.propTypes = {
  job: _propTypes.default.object.isRequired
};