"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Detectors = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _public = require("@kbn/kibana-react-plugin/public");
var _string_utils = require("../../../../../util/string_utils");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class Detectors extends _react.Component {
  constructor(props, constructorContext) {
    super(props, constructorContext);
    (0, _defineProperty2.default)(this, "onDescriptionChange", (e, i) => {
      const jobDetectorDescriptions = this.state.detectorDescriptions;
      jobDetectorDescriptions[i] = e.target.value;
      this.setDetectorDescriptions({
        jobDetectorDescriptions
      });
    });
    this.state = {
      detectors: [],
      detectorDescriptions: []
    };
    this.setDetectorDescriptions = props.setDetectorDescriptions;
  }
  static getDerivedStateFromProps(props) {
    return {
      detectors: props.jobDetectors,
      detectorDescriptions: props.jobDetectorDescriptions
    };
  }
  render() {
    const {
      detectors,
      detectorDescriptions
    } = this.state;
    return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiTitle, {
      size: "xs"
    }, /*#__PURE__*/_react.default.createElement("h4", null, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.ml.jobsList.editJobFlyout.detectors.title",
      defaultMessage: "Edit detector descriptions"
    }))), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
      size: "m"
    }), /*#__PURE__*/_react.default.createElement(_eui.EuiForm, null, detectorDescriptions.map((d, i) => /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
      label: (0, _string_utils.detectorToString)(detectors[i]),
      key: i
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFieldText, {
      value: d,
      onChange: e => this.onDescriptionChange(e, i)
    })))));
  }
}
exports.Detectors = Detectors;
(0, _defineProperty2.default)(Detectors, "contextType", _public.context);
Detectors.propTypes = {
  jobDetectors: _propTypes.default.array.isRequired,
  jobDetectorDescriptions: _propTypes.default.array.isRequired,
  setDetectorDescriptions: _propTypes.default.func.isRequired
};