"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExpandedRowJsonPane = void 0;
var _react = _interopRequireDefault(require("react"));
var _eui = require("@elastic/eui");
var _i18n = require("@kbn/i18n");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const ExpandedRowJsonPane = ({
  json,
  dataTestSubj
}) => {
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": dataTestSubj
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, null, /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s"
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCodeBlock, {
    "aria-label": _i18n.i18n.translate('xpack.ml.dataframe.analyticsList.analyticsDetails.expandedRowJsonPane', {
      defaultMessage: 'JSON of data frame analytics configuration'
    }),
    style: {
      width: '100%'
    },
    language: "json",
    fontSize: "s",
    paddingSize: "s",
    overflowHeight: 300,
    isCopyable: true,
    "data-test-subj": `mlAnalyticsDetailsJsonPreview`
  }, JSON.stringify(json, null, 2))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false
  }, "\xA0"));
};
exports.ExpandedRowJsonPane = ExpandedRowJsonPane;