"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useStopAction = void 0;
var _react = _interopRequireWildcard(require("react"));
var _common = require("../analytics_list/common");
var _analytics_service = require("../../services/analytics_service");
var _stop_action_name = require("./stop_action_name");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useStopAction = canStartStopDataFrameAnalytics => {
  const stopAnalytics = (0, _analytics_service.useStopAnalytics)();
  const [isModalVisible, setModalVisible] = (0, _react.useState)(false);
  const [item, setItem] = (0, _react.useState)();
  const closeModal = () => setModalVisible(false);
  const forceStopAndCloseModal = () => {
    if (item !== undefined) {
      setModalVisible(false);
      stopAnalytics(item);
    }
  };
  const openModal = newItem => {
    setItem(newItem);
    setModalVisible(true);
  };
  const clickHandler = (0, _react.useCallback)(i => {
    if (canStartStopDataFrameAnalytics) {
      if ((0, _common.isDataFrameAnalyticsFailed)(i.stats.state)) {
        openModal(i);
      } else {
        stopAnalytics(i);
      }
    }
  },
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [stopAnalytics]);
  const action = (0, _react.useMemo)(() => ({
    name: () => /*#__PURE__*/_react.default.createElement(_stop_action_name.StopActionName, {
      isDisabled: !canStartStopDataFrameAnalytics
    }),
    available: i => (0, _common.isDataFrameAnalyticsRunning)(i.stats.state) || (0, _common.isDataFrameAnalyticsFailed)(i.stats.state),
    enabled: () => canStartStopDataFrameAnalytics,
    description: _stop_action_name.stopActionNameText,
    icon: 'stop',
    type: 'icon',
    onClick: clickHandler,
    'data-test-subj': 'mlAnalyticsJobStopButton'
  }),
  // eslint-disable-next-line react-hooks/exhaustive-deps
  [clickHandler]);
  return {
    action,
    closeModal,
    isModalVisible,
    item,
    openModal,
    forceStopAndCloseModal
  };
};
exports.useStopAction = useStopAction;